% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{crop.borders}
\alias{crop.borders}
\title{Crop the outer margins of an image}
\usage{
crop.borders(im, nx = 0, ny = 0, nz = 0, nPix)
}
\arguments{
\item{im}{an image}

\item{nx}{number of pixels to crop along horizontal axis}

\item{ny}{number of pixels to crop along vertical axis}

\item{nz}{number of pixels to crop along depth axis}

\item{nPix}{optional: crop the same number of pixels along all dimensions}
}
\value{
an image
}
\description{
This function crops pixels on each side of an image. This function is a kind of inverse (centred) padding, and is useful e.g. when you want to get only the valid part of a convolution
}
\examples{
#These two versions are equivalent
imfill(10,10) \%>\% crop.borders(nx=1,ny=1)
imfill(10,10) \%>\% crop.borders(nPix=1)

#Filter, keep valid part
correlate(boats,imfill(3,3)) \%>\% crop.borders(nPix=2)
}
\author{
Simon Barthelme
}

