% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_network.R
\name{plot_network}
\alias{plot_network}
\alias{plot_network,ScoreResultNet-method}
\alias{plot_network,ScoreFP-method}
\alias{plot_network.ScoreResultNet}
\alias{plot_network.ScoreFP}
\title{plot_network}
\usage{
plot_network(
  x,
  Drug,
  node_color = c("orange", "lightblue"),
  layout = "layout_nicely",
  ...
)

\S4method{plot_network}{ScoreResultNet}(
  x,
  Drug,
  node_color = c("orange", "lightblue"),
  layout = "layout_nicely",
  node_type = "target"
)

\S4method{plot_network}{ScoreFP}(
  x,
  Drug,
  node_color = c("orange", "lightblue"),
  layout = "layout_nicely",
  highlight = NULL,
  width = FALSE
)

plot_network.ScoreResultNet(
  x,
  Drug,
  node_color = c("orange", "lightblue"),
  layout = "layout_nicely",
  node_type = "target"
)

plot_network.ScoreFP(
  x,
  Drug,
  node_color = c("orange", "lightblue"),
  layout = "layout_nicely",
  highlight = NULL,
  width = FALSE
)
}
\arguments{
\item{x}{ScoreFP or ScoreResultNet object}

\item{Drug}{The name of drug.}

\item{node_color}{The node color}

\item{layout}{Character Name of network layout function to use. Default to "layout_nicely".}

\item{...}{additional parameters}

\item{node_type}{one of "target" or "all"}

\item{highlight}{A character vector of gene.}

\item{width}{A logical. The number of overlapping genes between the two pathways is used as the width of the edges.}
}
\value{
visNetwork object
}
\description{
Drug target or pathway network visualization
}
\author{
Yuanlong Hu
}
