% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{check_distribution}
\alias{check_distribution}
\title{Check and normalise distributions}
\usage{
check_distribution(
  .data,
  .do.norm = NA,
  .laplace = 1,
  .na.val = 0,
  .warn.zero = FALSE,
  .warn.sum = TRUE
)
}
\arguments{
\item{.data}{Numeric vector of values.}

\item{.do.norm}{One of the three values - NA, TRUE or FALSE. If NA then check for distrubution (sum(.data) == 1)
and normalise if needed with the given laplace correction value. if TRUE then do normalisation and laplace
correction. If FALSE then don't do normalisaton and laplace correction.}

\item{.laplace}{Value for the laplace correction.}

\item{.na.val}{Replace all NAs with this value.}

\item{.warn.zero}{if TRUE then the function checks if in the resulted vector (after normalisation)
are any zeros, and prints a warning message if there are some.}

\item{.warn.sum}{if TRUE then the function checks if the sum of resulted vector (after normalisation)
is equal to one, and prints a warning message if not.}
}
\value{
Numeric vector.
}
\description{
Check if the given .data is a distribution and normalise it if necessary with an optional laplace correction.
}
\section{Developer Examples}{

immunarch:::check_distribution(c(1, 2, 3))
immunarch:::check_distribution(c(1, 2, 3), TRUE)
immunarch:::check_distribution(c(1, 2, 3), FALSE)
}

\concept{utility_private}
