% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_replacement_reconstruction.R
\name{codon_replacement_reconstruction}
\alias{codon_replacement_reconstruction}
\title{Decodes immuneSIM repertoire codon replacements events.}
\usage{
codon_replacement_reconstruction(codon_replacement_vec)
}
\arguments{
\item{codon_replacement_vec}{An vector containing strings describing codon replacement events as generated
by codon_replacement() function. The string contains information on every replacement event in the form:

"initial_codon:replacement_codon:number_of_occurrences"

which is combined into: "Replacement1|Replacement2|Replacement3".

(For example: "tac,tat:3|agc,agt:1|gtg,gtt:0".)}
}
\value{
List of dataframes. Each entry contains replacement info including count of occurrences for each simulated sequence.
}
\description{
Decodes immuneSIM repertoire codon replacements events.
}
\examples{
codon_replacement_example <- c("tat,tac:3|agt,agc:3|gtt,gtg:0", "tat,tac:1|agt,agc:1|gtt,gtg:1")
codon_replacement_list <- codon_replacement_reconstruction(codon_replacement_example)
}
