% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_prefix_remove.R
\name{HLA_prefix_remove}
\alias{HLA_prefix_remove}
\title{HLA_prefix_remove}
\usage{
HLA_prefix_remove(data)
}
\arguments{
\item{data}{A string with a single HLA allele.}
}
\value{
A string modified to remove HLA and locus prefixes.
}
\description{
This function removes HLA and locus prefixes from a string of HLA typing:
"HLA-A2" changes to "2".
}
\examples{
# The HLA_typing_1 dataset contains a table with HLA typing spread across multiple columns:
print(HLA_typing_1)

# The `HLA_prefix_remove` function can be used to get each column to have only the
# colon-separated fields:
library(dplyr)
HLA_typing_1 \%>\% mutate(
  across(
    A1:DPB1_2,
    ~ HLA_prefix_remove(.)
  )
)

}
