% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{Rmse}
\alias{Rmse}
\title{calculate the RMSE or NRMSE}
\usage{
Rmse(imp, mis, true, norm = FALSE)
}
\arguments{
\item{imp}{the imputaed data matrix}

\item{mis}{the missing data matrix}

\item{true}{the true data matrix}

\item{norm}{logical, if TRUE then the normalized RMSE will be returned}
}
\value{
the RMSE or NRMSE
}
\description{
This function calculate imputation error given the imputed data, the missing
data and the true data
}
\examples{
data(parkinson)
# introduce 10\% random missing values into the parkinson data
missdata <- SimIm(parkinson, 0.1)

# impute the missing values by LASSO
\donttest{impdata <- impute(missdata, lmFun = "lassoR")

# calculate the normalised RMSE for the imputation
Rmse(impdata$imp, missdata, parkinson, norm = TRUE)
}
}
\seealso{
\code{\link{impute}} for the main imputation function, 
\code{\link{mr}} for the misclassification error metric.
}
