% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/na.remove.R
\name{na.remove}
\alias{na.remove}
\title{Remove Missing Values}
\usage{
na.remove(data, na.identifier = NA)
}
\arguments{
\item{data}{Time Series (\code{\link{ts}}) object in which missing values are to be removed}

\item{na.identifier}{Missing Value Identifier.
If another value than NA indicates missing values this can be specified here.
Identifier can be a character string as well as a numeric value.}
}
\value{
Time Series (\code{\link{ts}}) object
}
\description{
Removes all missing values from a time series.
}
\details{
Removes all missing values from a time series. This shortens the time series by
the number of missing values in the series. Should be handled with care, because this can affect
the seasonality of the time series. Seasonal patterns might be destroyed and/or frequency parameter of the
ts object might be no more correct.
}
\examples{
#Create Time series with missing values
x <- ts(c(2,3,NA,5,6,NA,7,8))

#Remove all NAs
na.remove(x)

#Create another Time series with missing values (marked with "-")
x2 <- ts(c(2,3,"-",5,6,"-",7,8))

#Remove all missing values (identified with "-")
na.remove(x2, na.identifier ="-")
}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.mean}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}}
}

