% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_defunct.R
\name{na.kalman}
\alias{na.kalman}
\title{Deprecated use \code{\link[imputeTS]{na_kalman}} instead.}
\usage{
na.kalman(x, model = "StructTS", smooth = TRUE, nit = -1, maxgap = Inf, ...)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object in which missing values shall be replaced}

\item{model}{Model to be used. With this parameter the State Space Model
(on which KalmanSmooth is performed) can be chosen. Accepts the following input:

\itemize{

\item{"StructTS" - For using a structural model fitted by maximum
likelihood (using \link[stats]{StructTS}) } (default choice)

\item{"auto.arima" - For using the state space representation of
arima model (using \link[forecast]{auto.arima})}

}

For both auto.arima and StructTS additional parameters for model building can
be given with the \dots parameter

Additionally it is also possible to use a user created state space model
(See code Example 5). This state space model could for example be
obtained from another R package for structural time series modeling.
Furthermore providing the state space representation of a arima model
from \link[stats]{arima} is also possible. But it is important to note,
that user created state space models must meet the requirements specified
under \link[stats]{KalmanLike}. This means the user supplied state space
model has to be in form of a list with at least components T, Z, h , V, a, P, Pn.
(more details under \link[stats]{KalmanLike})}

\item{smooth}{if \code{TRUE} - \code{\link[stats]{KalmanSmooth}} is used for
estimation, if \code{FALSE} - \code{\link[stats]{KalmanRun}} is used.
Since KalmanRun is often considered extrapolation KalmanSmooth is usually
the better choice for imputation.}

\item{nit}{Parameter from Kalman Filtering (see \link[stats]{KalmanLike}).
Usually no need to change from default.}

\item{maxgap}{Maximum number of successive NAs to still perform imputation on.
Default setting is to replace all NAs without restrictions. With this
option set, consecutive NAs runs, that are longer than 'maxgap' will
be left NA. This option mostly makes sense if you want to
treat long runs of NA afterwards separately.}

\item{...}{Additional parameters to be passed through to the functions that
build the State Space Models (\link[stats]{StructTS} or \link[forecast]{auto.arima}).}
}
\description{
na.kalman is replaced by \code{\link[imputeTS]{na_kalman}}.
The functionality stays the same. The new name better fits modern R code
style guidelines (which prefer _ over . in function names).
}
\keyword{internal}
