% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimals.R
\name{getNDecimalsRule}
\alias{getNDecimalsRule}
\title{Get number of decimals based pre-defined rule(s).}
\usage{
getNDecimalsRule(x, rule = c("1"))
}
\arguments{
\item{x}{Numeric vector.}

\item{rule}{Character vector with rule to use to derive 
the number of parameters.
Currently only: '1' is implemented.
\itemize{
\item{'1': }{Standard rule for the number of 
decimals for individual values for a 
continuous variable is:
\itemize{
\item{value < 1 ('very small values')}{3}
\item{value < 10: }{2}
\item{value in [10, 1000[: }{1}
\item{value >= 1000: }{0}
}
}
}}
}
\value{
Numeric vector of same length than \code{x}
with the number of decimals.
}
\description{
Note: NA is returned if the element is missing (NA).
}
\examples{
x <- c(0.99, 5.679, 50.45, 1450)
getNDecimalsRule(x = x)
}
\author{
Laure Cougnaud
}
