% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSummaryStatisticsTable.R
\name{convertVarToFactorWithOrder}
\alias{convertVarToFactorWithOrder}
\title{Convert a variable to a factor with levels in specified order.}
\usage{
convertVarToFactorWithOrder(
  data,
  var,
  otherVars = NULL,
  colVar = NULL,
  colTotalLab = "Total",
  method = c("auto", "alphabetical", "total"),
  totalFilterFct = NULL,
  totalVar = "statN",
  catLast = NULL
)
}
\arguments{
\item{data}{Data.frame with dataset to consider for the summary table.}

\item{var}{String with variable of \code{data} to sort.}

\item{otherVars}{Character vector with other variable(s) of \code{data}
considered in the specific dimension.}

\item{colVar}{Character vector with variable(s) to be included in columns.
If multiple variables are specified, the variables should 
be sorted in hierarchical order,
and are included in multi-columns layout.\cr
Use: 'variable' to include the variables to summarize: \code{var}
 (if multiple) in different columns.}

\item{colTotalLab}{String, label for the total column  'Total' by default.\cr}

\item{method}{Ordering method to use, either:
\itemize{
\item{String among:
\itemize{
\item{'auto': if \code{var} is a factor, keep its order, otherwise alphabetically}
\item{'alphabetical': \code{var} is order in alphabetical order}
\item{'total': \code{var} is ordered based on the \code{totalVar} variable, in decreasing order.
The total count is extracted from the rows with all \code{otherVars} equal to 'Total'.
If no \code{otherVars} is specified, consider all rows.}
}
}
\item{Function to be applied on each subset to get the order elements of the variable}
}}

\item{totalFilterFct}{(optional) Function which returns a subset of the data of interest,
to filter the total data considered for the ordering.}

\item{totalVar}{String with variable of \code{data} considered in case \code{type} is 'total',
'statN' by default.}

\item{catLast}{String with last category (if any).
Set to NULL if no specific category should be included as last element.}
}
\value{
Factor \code{var} variable of \code{data} with specified order.
}
\description{
Convert a variable to a factor with levels in specified order.
}
\author{
Laure Cougnaud
}
\keyword{internal}
