% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_case_fct.R
\name{in_case_fct}
\alias{in_case_fct}
\alias{switch_case_fct}
\alias{grep_case_fct}
\alias{fn_case_fct}
\alias{fn_switch_case_fct}
\title{Case statements returning a factor}
\usage{
in_case_fct(..., preserve = FALSE, default = NA, ordered = FALSE)

switch_case_fct(x, ..., preserve = FALSE, default = NA, ordered = FALSE)

grep_case_fct(x, ..., preserve = FALSE, default = NA, ordered = FALSE)

fn_case_fct(x, fn, ..., preserve = FALSE, default = NA, ordered = FALSE)

fn_switch_case_fct(x, fn, ..., preserve = FALSE, default = NA, ordered = FALSE)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A sequence of two-sided
formulas or named arguments.
\itemize{
\item \strong{Formulas}: Elements of \code{x} that return \code{TRUE} when passed to \code{fn} with
the left hand side (LHS) of each formula will be replaced with the value in
the right hand side (RHS).
The LHS must evaluate to a logical vector when passed to \code{fn} with \code{x}.
The RHS must be of length 1 or the same length as all other RHS.
\item \strong{Named arguments}: named arguments are passed as additional arguments
to the function \code{fn}.
}}

\item{preserve}{If \code{TRUE}, unmatched elements of \code{x} will be returned
unmodified.
(The elements may have their type coerced to be compatible with
replacement values.)
If \code{FALSE}, unmatched elements of \code{x} will be replaced with \code{default}.
Defaults to \code{FALSE}.}

\item{default}{If \code{preserve} is \code{FALSE}, a value to replace unmatched
elements of \code{x}.
Defaults to \code{NA}.}

\item{ordered}{A logical.
If \code{\link{TRUE}}, returns an \link{ordered} factor.
If \code{\link{FALSE}}, returns an unordered factor.}

\item{x}{A vector}

\item{fn}{A function to apply to the left-hand side of each formula in \code{...}

Either a quoted or unquoted function name, an anonymous \code{\link{function}}, or
a \link[rlang:as_function]{purrr-style formula}.

The function should take two inputs, the first being \code{x} and the second
being the left-hand side of the formula.
The function should return a logical vector, either of length 1 or the same
length as \code{x}.}
}
\value{
A factor vector of length 1 or n, matching the length of the logical
input or output vectors.
Levels are determined by the order of inputs to \code{...}.
Inconsistent lengths will generate an error.
}
\description{
These functions are equivalent to \code{\link[=in_case]{in_case()}}, \code{\link[=switch_case]{switch_case()}},
\code{\link[=grep_case]{grep_case()}}, \code{\link[=fn_case]{fn_case()}}, and \code{\link[=fn_switch_case]{fn_switch_case()}} but return
\link[=factor]{factors} with their levels determined by the order of their
case statements.
}
\examples{
1:10 \%>\%
  in_case_fct(
    . \%\% 2 == 0 ~ "even",
    . \%\% 2 == 1 ~ "odd"
  )

switch_case_fct(
  c("a", "b", "c"),
  "c" ~ "cantaloupe",
  "b" ~ "banana",
  "a" ~ "apple"
)

switch_case_fct(
  c("a", "b", "c", "d"),
  "c" ~ "cantaloupe",
  "b" ~ "banana",
  "a" ~ "apple"
)

switch_case_fct(
  c("a", "b", "c", "d"),
  "c" ~ "cantaloupe",
  "b" ~ "banana",
  "a" ~ "apple",
  preserve = TRUE
)

grep_case_fct(
  c("caterpillar", "dogwood", "catastrophe", "dogma"),
  "cat" ~ "feline",
  "dog" ~ "canine"
)

fn_case_fct(
  c("a", "b", "c"),
  `\%in\%`,
  "c" ~ "cantaloupe",
  "b" ~ "banana",
  "a" ~ "apple"
)
}
\seealso{
\code{\link[=in_case]{in_case()}}, \code{\link[=switch_case]{switch_case()}}, \code{\link[=grep_case]{grep_case()}}, \code{\link[=fn_case]{fn_case()}}, and
\code{\link[=fn_case_fct]{fn_case_fct()}} on which these functions are based.
}
