% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.incidence}
\alias{plot.incidence}
\alias{add_incidence_fit}
\alias{plot.incidence_fit}
\alias{plot.incidence_fit_list}
\title{Plot function for incidence objects}
\usage{
\method{plot}{incidence}(x, ..., fit = NULL, stack = is.null(fit),
  color = "black", border = NA, col_pal = incidence_pal1,
  alpha = 0.7, xlab = "", ylab = NULL,
  labels_iso = !is.null(x$isoweeks), show_cases = FALSE,
  n_breaks = 6)

add_incidence_fit(p, x, col_pal = incidence_pal1)

\method{plot}{incidence_fit}(x, ...)

\method{plot}{incidence_fit_list}(x, ...)
}
\arguments{
\item{x}{An incidence object, generated by the function
\code{\link[=incidence]{incidence()}}.}

\item{...}{Further arguments passed to other methods (currently not used).}

\item{fit}{An 'incidence_fit' object as returned by \code{\link[=fit]{fit()}}.}

\item{stack}{A logical indicating if bars of multiple groups should be
stacked, or displayed side-by-side.}

\item{color}{The color to be used for the filling of the bars; NA for
invisible bars; defaults to "black".}

\item{border}{The color to be used for the borders of the bars; NA for
invisible borders; defaults to NA.}

\item{col_pal}{The color palette to be used for the groups; defaults to
\code{incidence_pal1}. See \code{\link[=incidence_pal1]{incidence_pal1()}} for other palettes implemented in
incidence.}

\item{alpha}{The alpha level for color transparency, with 1 being fully
opaque and 0 fully transparent; defaults to 0.7.}

\item{xlab}{The label to be used for the x-axis; empty by default.}

\item{ylab}{The label to be used for the y-axis; by default, a label will be
generated automatically according to the time interval used in incidence
computation.}

\item{labels_iso}{a logical value indicating whether labels x axis tick
marks are in ISO 8601 week format yyyy-Www when plotting ISO week-based weekly
incidence; defaults to be TRUE.}

\item{show_cases}{if \code{TRUE} (default: \code{FALSE}), then each observation will be
colored by a border. The border defaults to a white border unless specified
otherwise. This is normally used outbreaks with a small number of cases.
Note: this can only be used if \code{stack = TRUE}}

\item{n_breaks}{the ideal number of breaks to be used for the x-axis
labeling}

\item{p}{An existing incidence plot.}
}
\description{
This function is used to visualise the output of the \code{\link[=incidence]{incidence()}}
function, using the package \code{ggplot2}.
}
\examples{

if(require(outbreaks) && require(ggplot2)) { withAutoprint({
  onset <- ebola_sim$linelist$date_of_onset

  ## daily incidence
  inc <- incidence(onset)
  inc
  plot(inc)

  ## weekly incidence
  inc.week <- incidence(onset, interval = 7)
  inc.week
  plot(inc.week) # default to label x axis tick marks with isoweeks
  plot(inc.week, labels_iso = FALSE) # label x axis tick marks with dates
  plot(inc.week, border = "white") # with visible border

  ## use group information
  sex <- ebola_sim$linelist$gender
  inc.week.gender <- incidence(onset, interval = 7, groups = sex)
  plot(inc.week.gender)
  plot(inc.week.gender, labels_iso = FALSE)

  ## show individual cases at the beginning of the epidemic
  inc.week.8 <- subset(inc.week.gender, to = "2014-06-01")
  plot(inc.week.8, show_cases = TRUE, border = "black")

  ## customize plot with ggplot2
  plot(inc.week.8, show_cases = TRUE, border = "black") +
    theme_classic(base_size = 16) +
    theme(axis.text.x = element_text(angle = 90, hjust = 1, vjust = 0.5))

  ## adding fit
  fit <- fit_optim_split(inc.week.gender)$fit
  plot(inc.week.gender, fit = fit)
  plot(inc.week.gender, fit = fit, labels_iso = FALSE)
})}

}
\seealso{
The \code{\link[=incidence]{incidence()}} function to generate the 'incidence'
objects.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
Zhian N. Kamvar \email{zkamvar@gmail.com}
}
