% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inctools.R
\docType{package}
\name{inctools}
\alias{inctools}
\alias{inctools-package}
\title{inctools: a package for incidence estimation}
\description{
The inctools package uses methods described by Kassanjee, et al. 'A new general biomarker-based incidence estimator,' \emph{Epidemiology} (2012), to implement functions to calculate incidence and tests of incidence difference between two populations, as well as power and sample size constraints for different study scenarios.
inctools also provides functions for calculation of mean duration of recent infection and false recency rates from assays for recent infection.
}
\section{inctools Functions}{

inctools has functions \emph{frrcal} to estimate false recency rate; \emph{mdrical} to estimate mean duration of recent infection; \emph{incprops} and \emph{inccounts} to calculate estimates and confidence intervals for incidence and incidence difference, as well as other summary and inferential statistics related to the survey; \emph{incpower} to calculate sample size needed for a given power in a test of incidence difference, or vice versa; and \emph{incprecision}, which gives sample size needed for a given precision in the incidence estimate or vice versa.

For a longer introduction, see the introductory vignette for this package. Use browseVignettes(package = "inctools") to access the vignettes.
}

