% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ragged_double.R
\name{RaggedDouble}
\alias{RaggedDouble}
\title{RaggedDouble Class}
\description{
This is a ragged array which stores doubles (numeric values).
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RaggedDouble-new}{\code{RaggedDouble$new()}}
\item \href{#method-RaggedDouble-get_values}{\code{RaggedDouble$get_values()}}
\item \href{#method-RaggedDouble-get_length}{\code{RaggedDouble$get_length()}}
\item \href{#method-RaggedDouble-queue_update}{\code{RaggedDouble$queue_update()}}
\item \href{#method-RaggedDouble-queue_extend}{\code{RaggedDouble$queue_extend()}}
\item \href{#method-RaggedDouble-queue_shrink}{\code{RaggedDouble$queue_shrink()}}
\item \href{#method-RaggedDouble-size}{\code{RaggedDouble$size()}}
\item \href{#method-RaggedDouble-.update}{\code{RaggedDouble$.update()}}
\item \href{#method-RaggedDouble-.resize}{\code{RaggedDouble$.resize()}}
\item \href{#method-RaggedDouble-clone}{\code{RaggedDouble$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-new"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-new}{}}}
\subsection{Method \code{new()}}{
Create a new RaggedDouble
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$new(initial_values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{initial_values}}{a vector of the initial values for each individual}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-get_values}{}}}
\subsection{Method \code{get_values()}}{
Get the variable values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$get_values(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{optionally return a subset of the variable vector. If
\code{NULL}, return all values; if passed an [individual::Bitset]
or integer vector, return values of those individuals.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-get_length"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-get_length}{}}}
\subsection{Method \code{get_length()}}{
Get the lengths of the indiviudal elements in the ragged array
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$get_length(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{optionally only get lengths for a subset of persons. If
\code{NULL}, return all lengths; if passed an [individual::Bitset]
or integer vector, return lengths of arrays for those individuals.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-queue_update"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-queue_update}{}}}
\subsection{Method \code{queue_update()}}{
Queue an update for a variable. There are 4 types of variable update:

\enumerate{
 \item{Subset update: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a vector whose length matches the size of \code{index},
which represents the new values for that subset.}
 \item{Subset fill: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a single number, which fills the specified subset.}
 \item{Variable reset: }{The index vector is set to \code{NULL} and the argument \code{values}
replaces all of the current values in the simulation. \code{values} should be a vector
whose length should match the size of the population, which fills all the variable values in
the population}
 \item{Variable fill: }{The index vector is set to \code{NULL} and the argument \code{values}
should be a single number, which fills all of the variable values in
the population.}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$queue_update(values, index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{a list of numeric vectors}

\item{\code{index}}{is the index at which to apply the change, use \code{NULL} for the
fill options. If using indices, this may be either a vector of integers or
an [individual::Bitset].}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-queue_extend"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-queue_extend}{}}}
\subsection{Method \code{queue_extend()}}{
extend the variable with new values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$queue_extend(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{to add to the variable}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-queue_shrink"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-queue_shrink}{}}}
\subsection{Method \code{queue_shrink()}}{
shrink the variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$queue_shrink(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{a bitset or vector representing the individuals to remove}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-size"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-size}{}}}
\subsection{Method \code{size()}}{
get the size of the variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$size()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-.update"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-.update}{}}}
\subsection{Method \code{.update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$.update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-.resize"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-.resize}{}}}
\subsection{Method \code{.resize()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$.resize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RaggedDouble-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RaggedDouble-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RaggedDouble$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
