% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\title{Visualize the distribution of the simulation-based inferential statistics
or the theoretical distribution (or both!)}
\usage{
visualize(data, bins = 15, method = "simulation", dens_color = "black",
  obs_stat = NULL, obs_stat_color = "red2", pvalue_fill = "pink",
  direction = NULL, endpoints = NULL,
  endpoints_color = "mediumaquamarine", ci_fill = "turquoise", ...)
}
\arguments{
\item{data}{the output from \code{\link{calculate}}}

\item{bins}{the number of bins in the histogram}

\item{method}{a string giving the method to display. Options are 
"simulation", "theoretical", or "both"
with "both" corresponding to "simulation" and "theoretical"}

\item{dens_color}{a character or hex string specifying the color of the
theoretical density curve}

\item{obs_stat}{a numeric value or 1x1 data frame corresponding to what
the observed statistic is}

\item{obs_stat_color}{a character or hex string specifying the color of
the observed statistic as a vertical line on the plot}

\item{pvalue_fill}{a character or hex string specifying the color to shade
the pvalue. In previous versions of the package this was the \code{shade_color} 
argument}

\item{direction}{a string specifying in which direction the shading 
should occur. Options are "less", "greater", or "two_sided" for p-value.
Can also give "left", "right", or "both" for p-value. For confidence 
intervals, use "between".
and give the endpoint values in \code{endpoints}}

\item{endpoints}{a 2 element vector or a 1 x 2 data frame containing the
lower and upper values to be plotted. Most useful for visualizing
conference intervals.}

\item{endpoints_color}{a character or hex string specifying the color of
the observed statistic as a vertical line on the plot}

\item{ci_fill}{a character or hex string specifying the color to shade
the confidence interval}

\item{...}{other arguments passed along to ggplot2}
}
\value{
A ggplot object showing the simulation-based distribution as a
 histogram or bar graph. Also used to show the theoretical curves.
}
\description{
Visualize the distribution of the simulation-based inferential statistics
or the theoretical distribution (or both!)
}
\examples{
# Permutations to create a simulation-based null distribution for 
# one numerical response and one categorical predictor
# using t statistic
mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
    hypothesize(null = "independence") \%>\%
    generate(reps = 100, type = "permute") \%>\%
    calculate(stat = "t", order = c("1", "0")) \%>\%
    visualize(method = "simulation") #default method

# Theoretical t distribution for 
# one numerical response and one categorical predictor
# using t statistic
mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
    hypothesize(null = "independence") \%>\%
    # generate() is not needed since we are not doing simulation
    calculate(stat = "t", order = c("1", "0")) \%>\%
    visualize(method = "theoretical")

# Overlay theoretical distribution on top of randomized t-statistics
mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    specify(mpg ~ am) \%>\% # alt: response = mpg, explanatory = am
    hypothesize(null = "independence") \%>\%
    generate(reps = 100, type = "permute") \%>\%
    calculate(stat = "t", order = c("1", "0")) \%>\%
    visualize(method = "both")
}
