% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{hypothesize}
\alias{hypothesize}
\title{Declare a null hypothesis}
\usage{
hypothesize(x, null, p = NULL, mu = NULL, med = NULL, sigma = NULL)
}
\arguments{
\item{x}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{null}{The null hypothesis. Options include \code{"independence"} and
\code{"point"}.}

\item{p}{The true proportion of successes (a number between 0 and 1). To be used with point null hypotheses when the specified response
variable is categorical.}

\item{mu}{The true mean (any numerical value). To be used with point null
hypotheses when the specified response variable is continuous.}

\item{med}{The true median (any numerical value). To be used with point null
hypotheses when the specified response variable is continuous.}

\item{sigma}{The true standard deviation (any numerical value). To be used with
point null hypotheses.}
}
\value{
A tibble containing the response (and explanatory, if specified)
variable data with parameter information stored as well.
}
\description{
Declare a null hypothesis
}
\examples{
# Permutation test similar to ANOVA
mtcars \%>\%
  dplyr::mutate(cyl = factor(cyl)) \%>\%
  specify(mpg ~ cyl) \%>\%
  hypothesize(null = "independence") \%>\%
  generate(reps = 100, type = "permute") \%>\%
  calculate(stat = "F")

}
