% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t-test.R
\name{ttest}
\alias{ttest}
\title{One Sample t Test}
\usage{
ttest(x, mu = 0, alpha = 0.05, type = c("both", "less", "greater", "all"),
  ...)
}
\arguments{
\item{x}{a numeric vector}

\item{mu}{a number indicating the true value of the mean}

\item{alpha}{acceptable tolerance for type I error}

\item{type}{a character string specifying the alternative hypothesis, must be
one of "both" (default), "greater", "less" or "all". You can specify just the
initial letter}

\item{...}{additional arguments passed to or from other methods}
}
\value{
\code{ttest} returns an object of class \code{"ttest"}.
An object of class \code{"ttest"} is a list containing the
following components:

\item{mu}{a number indicating the true value of the mean}
\item{n}{number of observations}
\item{df}{degrees of freedom}
\item{Mean}{observed mean of \code{x}}
\item{stddev}{standard deviation of \code{x}}
\item{std_err}{estimate of standard error}
\item{test_stat}{t statistic}
\item{confint}{confidence interval for the mean}
\item{mean_diff}{mean difference}
\item{mean_diff_l}{lower confidence limit for mean difference}
\item{mean_diff_u}{upper confidence limit for mean difference}
\item{p_l}{lower one-sided p-value}
\item{p_u}{upper one-sided p-value}
\item{p}{two sided p-value}
\item{conf}{confidence level}
\item{type}{alternative hypothesis}
\item{var_name}{name of \code{x}}
}
\description{
\code{ttest} performs t tests on the equality of means. It tests the
hypothesis that a sample has a mean equal to a hypothesized value.
}
\examples{
# lower tail
ttest(hsb$write, mu = 50, type = 'less')

# upper tail
ttest(hsb$write, mu = 50, type = 'greater')

# both tails
ttest(hsb$write, mu = 50, type = 'both')

# all tails
ttest(hsb$write, mu = 50, type = 'all')
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{t.test}}
}

