% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influenceAUC.R
\name{LAUC}
\alias{LAUC}
\title{Local Influence Approaches On AUC}
\usage{
LAUC(score, binary, threshold = 0.2, name = NULL)
}
\arguments{
\item{score}{A vector containing the predictions (continuous scores) assigned by classifiers; Must be numeric.}

\item{binary}{A vector containing the true class labels 1: positive and 0: negative. Must have the same dimensions as 'score.'}

\item{threshold}{A numeric value determining the threshold to distinguish influential observations from normal ones; Must lie between 0 and 1; Defaults to 0.2.}

\item{name}{A vector comprising the appellations for observations; Must have the same dimensions as 'score.'}
}
\value{
A list of objects including (1) `output`: a list of results with `AUC` (numeric), `Slope` (a list of dataframes) and `Curvature` (a list of dataframes)); (2) `rdata`: a dataframe of essential results for visualization
(3) `threshold`: a used numeric value to distinguish influential observations from normal ones.
}
\description{
Apply local influence approaches in terms of slope and curvature on the AUC to quantify the impacts of all observations simultaneously.
}
\details{
The influence functions on the AUC focus on the deletion diagnostics; however, such approaches may encounter the masking effect. Rather than dealing with single observations
once at a time, local influence methods address this issue by finding the weighted direction of all observations accompanied by the greatest (magnitude) slope and curvature. From the explicit formula based on
the slope, local influence methods may face the imbalanced data effect. To thoroughly investigate the potential observation in binary classification, we suggest end-users to apply \code{\link{ICLC}} and \code{\link{IAUC}} as well.
For a complete discussion of these functions, please see the reference.
}
\examples{
library(ROCR)
data("ROCR.simple")
# print out LAUC results directly
LAUC(ROCR.simple$predictions,ROCR.simple$labels)

data(mtcars)
glmfit <- glm(vs ~ wt + disp, family = binomial, data = mtcars)
prob <- as.vector(predict(glmfit, newdata = mtcars, type = "response"))
output <- LAUC(prob, mtcars$vs, name = rownames(mtcars))
# Show results
print(output)
# Visualize results
plot(output)
}
\references{
Ke, B. S., Chiang, A. J., & Chang, Y. C. I. (2018). Influence Analysis for the Area Under the Receiver Operating Characteristic Curve. Journal of biopharmaceutical statistics, 28(4), 722-734.
}
\seealso{
\code{\link{ICLC}}, \code{\link{IAUC}}
}
\author{
Bo-Shiang Ke and Yuan-chin Ivan Chang
}
