% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informSCI.R
\name{inExactSCI}
\alias{inExactSCI}
\title{Checking Precision of Approximations}
\usage{
inExactSCI(
  L,
  randomShifts = 0,
  shifts = NULL,
  tolTrueSCI,
  gMCP = NULL,
  g = NULL,
  weights = NULL,
  q,
  estimates = NULL,
  Z = NULL,
  pValues = NULL,
  SE = NULL,
  I = NULL,
  mu_0,
  alpha,
  checkInput = TRUE
)
}
\arguments{
\item{L}{An m-dimensional non-negative vector whose entries are the lower
bounds of an approximation of the informative SCI.}

\item{randomShifts}{A positive integer indicating how many random directions
of length \code{tolTrueSCI} should be generated.}

\item{shifts}{A matrix with m columns and any number of rows. Each entry must
be non-negative. Each row is a direction in the m-dimensional real space.
Each row must have at least one positive entry. \code{randomShifts} should
be a positive integer or \code{shifts} should contain at least one row.}

\item{tolTrueSCI}{The randomly generated shift-vectors and the row vectors
in \code{shifts} are rescaled to have length \code{tolTrueSCI}.}

\item{gMCP}{An object of class \code{\link[gMCP]{graphMCP}} indicating the
underlying graphical test.}

\item{g}{Numeric square matrix of transition weights for the graphical test
with m rows and m columns. The i-th row of the entered matrix defines the
arrows starting from the i-th hypothesis. Each entry has to be between
0 and 1 and each row must sum to a number less than or equal to 1. The
diagonal elements must be zero. Entering \code{g} and \code{weights} can be
used as the input as an alternative to specifying \code{gMCP}.}

\item{weights}{Numeric vector of weights of dimension m. It defines the
initial proportion of significance level which is assigned to each null
hypothesis. Entering \code{g} and \code{weights} can be used as the input as
an alternative to specifying \code{gMCP}.}

\item{q}{A numeric vector of dimension 1 or m defining the information
weights for each hypothesis. The entries have to be between 0 and 1
(inclusive). If \code{q} has dimension 1, the same information weight is
used for each hypothesis.}

\item{estimates}{An m-dimensional numeric vector of unbiased point estimates
for the parameters of interest. Each estimator is assumed to be
(asymptotically) normal.}

\item{Z}{An m-dimensional numeric vector of z-scores for testing the null
hypotheses. \code{Z} can be entered as an alternative to \code{estimates}.}

\item{pValues}{An m-dimensional numeric vector of p-values from (asymptotic)
z-tests for testing the null hypotheses. \code{pValues} can be entered as an
alternative to \code{estimates} and \code{Z}.}

\item{SE}{A positive numeric vector of dimension 1 or m indicating the
standard errors of the point estimators. If \code{SE} has dimension 1, the
same value is used for each estimator.}

\item{I}{A positive numeric vector indicating the information of the
estimators. It can be entered as an alternative to the vector \code{SE}.
The relationship \code{SE}\eqn{=1/}\code{I}\eqn{^{1/2}} is assumed.}

\item{mu_0}{A numeric vector of dimension 1 or m defining the bounds of the
null hypotheses of the underlying graphical test. If \code{mu_0} has
dimension 1, the same value is used for each null hypothesis.}

\item{alpha}{A numeric defining the overall significance level for the
graphical test (i.e. SCIs will have coverage probability of at least
\eqn{1-}\code{alpha}. The parameter must be strictly between 0 and 1.}

\item{checkInput}{A boolean specifying whether the entered values should be
checked.}
}
\value{
Returns \code{TRUE} if we can determine that the approximation is
indeed precise. Returns \code{FALSE} if we cannot determine that the
approximation is precise. (The approximation may still be precise.)
}
\description{
The functions checks whether information about the precision of an
approximation for the informative lower SCI-bounds can be collected.
}
\details{
The function checks if it can be determined whether \code{L} can be shifted
by a randomly generated rescaled direction or by a rescaled direction in the
shift matrix such that it lies in the true SCI. If this is possible,
the approximation is precise.
(The random directions are generated in such a way that all entries are
positive.)

Let m be the dimension of \code{L}. m also describes the number of
hypotheses of interest.
}
\examples{
g <- matrix(c(0,0,1,0),2,2)
weights <- c(1,0)
q <- c(0.0068,1)
mu_0 <- c(-1,0)
pValues <- c(0.0002,0.01)
SE <- c(0.31,1.11)
alpha <- 0.025
L <- informSCI(g=g, weights=weights, q=q, mu_0=mu_0, pValues=pValues, SE=SE,
alpha=alpha, eps=1/10^5, tolBisec=1/10^5)$L
# When the randomShifts- or shift-parameter in the informSCI-function is
# specified, the inExactSCI-function is called by the informSCI-function.
# It is also possible to analyse the accuracy of a calculated L (or an 
# approximation of the lower informative SCI-bounds) by directly using 
# the inExactSCI-function:
inExactSCI(L=L, randomShifts=100, tolTrueSCI=1/10^5, g=g, weights=weights,
q=q, pValues=pValues, SE=SE, mu_0=mu_0, alpha=alpha)
}
\seealso{
\code{\link{informSCI}} \code{\link{explore_q}}
}
