% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_variable_profile.R
\name{calculate_variable_split}
\alias{calculate_variable_split}
\title{Internal Function for Split Points for Selected Variables}
\usage{
calculate_variable_split(data, variables = colnames(data),
  grid_points = 101)
}
\arguments{
\item{data}{validation dataset. Is used to determine distribution of observations.}

\item{variables}{names of variables for which splits shall be calculated}

\item{grid_points}{number of points used for response path}
}
\value{
A named list with splits for selected variables
}
\description{
This function calculate candidate splits for each selected variable.
For numerical variables splits are calculated as percentiles
(in general uniform quantiles of the length grid_points).
For all other variables splits are calculated as unique values.
}
\details{
Note that \code{calculate_variable_split} function is S3 generic.
If you want to work on non standard data sources (like H2O ddf, external databases)
you should overload it.
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
                                      no.rooms + district, data = apartments)
vars <- c("construction.year", "surface", "floor", "no.rooms", "district")
calculate_variable_split(apartments, vars)
}
}
