% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_dependency.R
\name{conditional_dependency}
\alias{conditional_dependency}
\alias{conditional_dependency.explainer}
\alias{conditional_dependency.default}
\alias{conditional_dependency.ceteris_paribus_explainer}
\alias{local_dependency}
\title{Conditional Dependency Profiles}
\usage{
conditional_dependency(x, ...)

\method{conditional_dependency}{explainer}(x, variables = NULL,
  N = 500, variable_splits = NULL, grid_points = 101, ...)

\method{conditional_dependency}{default}(x, data,
  predict_function = predict, label = class(x)[1], variables = NULL,
  grid_points = grid_points, variable_splits = variable_splits,
  N = 500, ...)

\method{conditional_dependency}{ceteris_paribus_explainer}(x, ...,
  variables = NULL)

local_dependency(x, ...)
}
\arguments{
\item{x}{a model to be explained, or an explainer created with function `DALEX::explain()` or  object of the class `ceteris_paribus_explainer`.}

\item{...}{other parameters}

\item{variables}{names of variables for which profiles shall be calculated. Will be passed to `calculate_variable_splits()`. If NULL then all variables from the validation data will be used.}

\item{N}{number of observations used for calculation of partial dependency profiles. By default 500.}

\item{variable_splits}{named list of splits for variables, in most cases created with `calculate_variable_splits()`. If NULL then it will be calculated based on validation data avaliable in the `explainer`.}

\item{grid_points}{number of points for profile. Will be passed to `calculate_variable_splits()`.}

\item{data}{validation dataset, will be extracted from `x` if it's an explainer}

\item{predict_function}{predict function, will be extracted from `x` if it's an explainer}

\item{label}{name of the model. By default it's extracted from the 'class' attribute of the model}
}
\value{
an 'aggregated_profile_explainer' layer
}
\description{
Conditional Dependency Profiles (aka Local Profiles) average localy Ceteris Paribus Profiles.
Function 'conditional_dependency' calls 'ceteris_paribus' and then 'aggregate_profiles'.
}
\details{
Find more detailes in \href{https://pbiecek.github.io/PM_VEE/conditionalProfiles.html}{Local Dependency Profiles Chapter}.
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")

pdp_rf <- conditional_dependency(explain_titanic_glm, N = 50)
plot(pdp_rf)

 \donttest{
library("titanic")
library("randomForest")

titanic_small <- titanic_train[,c("Survived", "Pclass", "Sex", "Age",
                                   "SibSp", "Parch", "Fare", "Embarked")]
titanic_small$Survived <- factor(titanic_small$Survived)
titanic_small$Sex <- factor(titanic_small$Sex)
titanic_small$Embarked <- factor(titanic_small$Embarked)
titanic_small <- na.omit(titanic_small)
rf_model <- randomForest(Survived ~ Pclass + Sex + Age + SibSp + Parch + Fare + Embarked,
                         data = titanic_small)
explainer_rf <- explain(rf_model, data = titanic_small,
                        y = titanic_small$Survived == "1", label = "RF")

pdp_rf <- conditional_dependency(explainer_rf)
plot(pdp_rf)
}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
