% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accumulated_dependency.R
\name{accumulated_dependency}
\alias{accumulated_dependency}
\alias{accumulated_dependency.explainer}
\alias{accumulated_dependency.default}
\alias{accumulated_dependency.ceteris_paribus_explainer}
\title{Accumulated Local Effects Profiles aka ALEPlots}
\usage{
accumulated_dependency(x, ...)

\method{accumulated_dependency}{explainer}(x, variables = NULL,
  N = 500, variable_splits = NULL, grid_points = 101, ...,
  variable_type = "numerical")

\method{accumulated_dependency}{default}(x, data,
  predict_function = predict, label = class(x)[1], variables = NULL,
  N = 500, variable_splits = NULL, grid_points = 101, ...,
  variable_type = "numerical")

\method{accumulated_dependency}{ceteris_paribus_explainer}(x, ...,
  variables = NULL)
}
\arguments{
\item{x}{an explainer created with function \code{DALEX::explain()}, an object of the class \code{ceteris_paribus_explainer}
or a model to be explained.}

\item{...}{other parameters}

\item{variables}{names of variables for which profiles shall be calculated.
Will be passed to \code{\link{calculate_variable_split}}.
If \code{NULL} then all variables from the validation data will be used.}

\item{N}{number of observations used for calculation of partial dependency profiles.
By default, 500 observations will be chosen randomly.}

\item{variable_splits}{named list of splits for variables, in most cases created with \code{\link{calculate_variable_split}}.
If \code{NULL} then it will be calculated based on validation data avaliable in the \code{explainer}.}

\item{grid_points}{number of points for profile. Will be passed to\code{\link{calculate_variable_split}}.}

\item{variable_type}{a character. If "numerical" then only numerical variables will be calculated.
If "categorical" then only categorical variables will be calculated.}

\item{data}{validation dataset Will be extracted from \code{x} if it's an explainer
NOTE: It is best when target variable is not present in the \code{data}}

\item{predict_function}{predict function Will be extracted from \code{x} if it's an explainer}

\item{label}{name of the model. By default it's extracted from the \code{class} attribute of the model}
}
\value{
an object of the class \code{aggregated_profiles_explainer}
}
\description{
Accumulated Local Effects Profiles accumulate local changes in Ceteris Paribus Profiles.
Function \code{\link{accumulated_dependency}} calls \code{\link{ceteris_paribus}} and then \code{\link{aggregate_profiles}}.
}
\details{
Find more detailes in the \href{https://pbiecek.github.io/PM_VEE/accumulatedLocalProfiles.html}{Accumulated Local Dependency Chapter}.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8],
                               verbose = FALSE)

adp_glm <- accumulated_dependency(explain_titanic_glm,
                                  N = 150, variables = c("age", "fare"))
head(adp_glm)
plot(adp_glm)

\donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              verbose = FALSE)

adp_rf <- accumulated_dependency(explain_titanic_rf, N = 200, variable_type = "numerical")
plot(adp_rf)

adp_rf <- accumulated_dependency(explain_titanic_rf, N = 200, variable_type = "categorical")
plotD3(adp_rf, variable_type = "categorical", label_margin = 80, scale_plot = TRUE)
}

}
\references{
ALEPlot: Accumulated Local Effects (ALE) Plots and Partial Dependence (PD) Plots \url{https://cran.r-project.org/package=ALEPlot},
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
