% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsample.R
\name{point2count}
\alias{point2count}
\title{Convert a plot sample of points into one of counts.}
\usage{
point2count(plots, dets)
}
\arguments{
\item{plots}{A \code{SpatialPolygonsDataFrame} object containing the plots that were 
sampled.}

\item{dets}{A \code{SpatialPointsDataFrame} object containing the locations of the 
points within the plots.}
}
\value{
A \code{SpatialPolygonsDataFrame} with counts in each plot contained in slot @data$n.
}
\description{
Converts a plot sample with locations of each point within each plot, into a plot
sample with only the count within each plot.
}
\examples{
\donttest{
library(raster)
data(gorillas)
plotpts = plotsample(gorillas$nests,gorillas$boundary,x.ppn=0.4,y.ppn=0.4,nx=5,ny=5)
p1 = ggplot() +gg(plotpts$plots) +gg(plotpts$dets) +gg(gorillas$boundary)
countdata = point2count(plotpts$plots,plotpts$dets)
x=coordinates(countdata)[,1]
y=coordinates(countdata)[,2]
count=countdata@data$n
p2 = ggplot() +gg(gorillas$boundary) +gg(plotpts$plots) +  geom_text(aes(label=count, x=x, y=y))
multiplot(p1,p2,cols=2)
}
}
