% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{bru_mapper}
\alias{bru_mapper}
\alias{ibm_n}
\alias{ibm_values}
\alias{ibm_amatrix}
\alias{ibm_valid_input}
\alias{bru_mapper.default}
\alias{bru_mapper.inla.mesh}
\alias{bru_mapper.inla.mesh.1d}
\alias{bru_mapper_index}
\alias{bru_mapper_linear}
\alias{bru_mapper_factor}
\alias{bru_mapper_offset}
\alias{bru_mapper_multi}
\title{Methods for \code{bru_mapper} objects}
\usage{
bru_mapper(...)

ibm_n(mapper, ...)

ibm_values(mapper, ...)

ibm_amatrix(mapper, input, ...)

ibm_valid_input(mapper, input, ...)

\method{bru_mapper}{default}(
  mapper,
  new_class = NULL,
  ibm_n = NULL,
  ibm_values = NULL,
  ibm_amatrix = NULL,
  ibm_valid_input = NULL,
  ...
)

\method{bru_mapper}{inla.mesh}(mesh, ...)

\method{bru_mapper}{inla.mesh.1d}(mesh, indexed = NULL, ...)

bru_mapper_index(n = 1L, ...)

bru_mapper_linear(...)

bru_mapper_factor(values, factor_mapping, ...)

bru_mapper_offset(...)

bru_mapper_multi(mappers, ...)
}
\arguments{
\item{\dots}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, normally inheriting from \code{bru_mapper}.
For the default \code{bru_mapper} method, a list that will be converted to a
\code{bru_mapper} object by adding class information and (optional) methods.}

\item{input}{The values for which to produce validity information}

\item{new_class}{If non-\code{NULL}, this is added at the front of the class definition}

\item{ibm_n}{An \code{ibm_n} method function}

\item{ibm_values}{An \code{ibm_values} method function}

\item{ibm_amatrix}{An \code{ibm_amatrix} method function}

\item{ibm_valid_input}{An \code{ibm_valid_input} method function}

\item{mesh}{An \code{inla.mesh.1d} or \code{inla.mesh.2d} object to use as a mapper}

\item{indexed}{logical; If \code{TRUE}, the \code{ibm_values()} output will be the
integer indexing sequence for the latent variables (needed for \code{spde} models).
If \code{FALSE}, the knot
locations are returned (useful as an interpolator for \code{rw2} models
and similar).
Default: \code{NULL}, to force user specification of this parameter}

\item{n}{Size of a model for \code{bru_mapper_index}}

\item{values}{Input values calculated by \code{\link[=input_eval.bru_input]{input_eval.bru_input()}}}

\item{factor_mapping}{character; selects the type of factor mapping.
\itemize{
\item \code{'contrast'} for leaving out the first factor level.
\item \code{'full'} for keeping all levels.
}}

\item{mappers}{A list of \code{bru_mapper} objects}
}
\description{
Methods for \code{bru_mapper} objects
}
\details{
\itemize{
\item \code{bru_mapper} Generic mapper S3 constructor. See below for details of the
default constructor that can be used to define new mappers in user code.
}

\itemize{
\item \code{ibm_n} Generic. Implementations must return the size of the latent vector
being mapped to.
}

\itemize{
\item \code{ibm_values} Generic. Implementations must return a vector that
is interpretable by an \code{INLA::f(..., values = ...)} specification, and
has length \code{\link[=ibm_n]{ibm_n()}}.
}

\itemize{
\item \code{ibm_amatrix} Generic.
Implementations must return a (sparse) matrix of size \code{NROW(input)}
(except for the \code{bru_mapper_multi} method)
by \code{ibm_n(mapper)}
}

\itemize{
\item \code{ibm_valid_input} Generic.
Implementations must return a logical vector of length \code{NROW(input)}
}

\itemize{
\item \code{bru_mapper.default} adds the "bru_mapper" class and \code{new_class}
to an object. If provided, mapper method functions are added to an environment
\code{.envir} in the object.  The generic methods \code{ibm_n}, \code{ibm_values},
\code{ibm_amatrix}, and \code{ibm_valid_input} look for these functions first,
and otherwise call \code{UseMethod()}.  This is an alternative to using \code{.S3method()}
to register the methods, e.g.
\code{.S3method("ibm_amatrix", "my_mapper_class", ibm_amatrix.my_mapper_class)}.
}

\itemize{
\item \code{bru_mapper_multi} constructs a kronecker product mapping
}
}
\examples{
mapper <- bru_mapper_index(5)
ibm_amatrix(mapper, c(1,3,4,5,2))
}
\seealso{
\link{bru_mapper_methods} for specific method implementations.
}
