% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.R
\name{glplot.SpatialLines}
\alias{glplot.SpatialLines}
\title{Visualize SpatialLines using RGL}
\usage{
\method{glplot}{SpatialLines}(object, add = TRUE, ...)
}
\arguments{
\item{object}{a SpatialLines or SpatialLinesDataFrame object.}

\item{add}{If TRUE, add the lines to an existing plot. If FALSE, create new plot.}

\item{...}{Parameters passed on to rgl.linestrips().}
}
\description{
This function will calculate a cartesian representation of the lines provided
and use rgl.linestrip() in order to render them.
}
\examples{
\dontrun{
if (bru_safe_inla() &&
  require("rgl", quietly = TRUE) &&
  require("sphereplot", quietly = TRUE)) {

  # Load pantropoical dolphin data

  data("mexdolphin", package = "inlabru")

  # Show the globe

  globe()

  # Add mesh, ship transects and dolphin sightings stored
  # as inla.mesh, SpatialLines and SpatialPoints objects, respectively

  glplot(mexdolphin$mesh)
  glplot(mexdolphin$samplers)
  glplot(mexdolphin$points)
}
}
}
\seealso{
Other inlabru RGL tools: 
\code{\link{globe}()},
\code{\link{glplot.SpatialPoints}()},
\code{\link{glplot.inla.mesh}()},
\code{\link{glplot}()}
}
\concept{inlabru RGL tools}
