% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{bru_get_mapper}
\alias{bru_get_mapper}
\alias{bru_get_mapper.inla.spde}
\alias{bru_get_mapper.inla.rgeneric}
\alias{bru_get_mapper_safely}
\title{Extract mapper information from INLA model component objects}
\usage{
bru_get_mapper(model, ...)

\method{bru_get_mapper}{inla.spde}(model, ...)

\method{bru_get_mapper}{inla.rgeneric}(model, ...)

bru_get_mapper_safely(model, ...)
}
\arguments{
\item{model}{A model component object}

\item{\dots}{Arguments passed on to other methods}
}
\value{
A \link{bru_mapper} object defined by the model component
}
\description{
The component definitions will automatically attempt to extract mapper
information from any model object by calling the generic \code{bru_get_mapper}.
Any class method implementation should return a \link{bru_mapper} object suitable
for the given latent model.
}
\details{
\itemize{
\item \code{bru_get_mapper.inla.spde} extract an indexed mapper for
the \code{model$mesh} object contained in the model object.
It returns \code{NULL} gives a warning
if no known mesh type is found in the model object.
}

\itemize{
\item \code{bru_get_mapper.inla.rgeneric} returns the mapper given by a call to
\code{model$f$rgeneric$definition("mapper")}. To support this for your own
\code{inla.rgeneric} models, add a \code{"mapper"} option to the \code{cmd} argument
of your rgeneric definition function. You will need to store the mapper
in your object as well.  Alternative, define your model using a subclass
and define a corresponding \code{bru_get_mapper.subclass} method that should return
the corresponding \code{bru_mapper} object.
}

\itemize{
\item \code{bru_get_mapper_safely} tries to call the \code{bru_get_mapper},
and returns \code{NULL} if it fails (e.g. due to no available class method).
If the call succeeds and returns non-\code{NULL}, it checks that the object
inherits from the \code{bru_mapper} class, and gives an error if it does not.
}
}
\examples{
if (bru_safe_inla(quietly = TRUE)) {
  library(INLA)
  mesh <- inla.mesh.create(globe = 2)
  spde <- inla.spde2.pcmatern(mesh,
    prior.range = c(1, 0.5),
    prior.sigma = c(1, 0.5)
  )
  mapper <- bru_get_mapper(spde)
  ibm_n(mapper)
}
}
\seealso{
\link{bru_mapper} for mapper constructor methods, and
\link{bru_mapper_methods} for method generics and specific implementations.
}
