% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_mesh.R
\name{fm_pixels}
\alias{fm_pixels}
\title{Generate lattice points covering a mesh}
\usage{
fm_pixels(mesh, nx = 150, ny = 150, mask = TRUE, format = "sf")
}
\arguments{
\item{mesh}{An \code{inla.mesh} object}

\item{nx}{Number of pixels in x direction}

\item{ny}{Number of pixels in y direction}

\item{mask}{If logical and TRUE, remove pixels that are outside the mesh.
If \code{mask} is an \code{sf} or \code{Spatial} object, only return pixels covered by this object.}

\item{format}{character; "sf", "terra" or "sp"}
}
\value{
\code{sf}, \code{SpatRaster}, or \code{SpatialPixelsDataFrame} covering the mesh
}
\description{
Generate \code{terra}, \code{sf}, or \code{sp} lattice locations
}
\examples{
\donttest{
if (require(ggplot2, quietly = TRUE)) {
  data("mrsea", package = "inlabru")
  pxl <- fm_pixels(mrsea$mesh,
    nx = 50, ny = 50, mask = mrsea$boundary,
    format = "terra"
  )
  ggplot() +
    gg(pxl, fill = "grey", alpha = 0.5) +
    gg(mrsea$mesh)
}
}

}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com} and
Finn Lindgren \email{finn.lindgren@gmail.com}
}
