% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_parm_data.R
\name{tabulate_parm_data}
\alias{tabulate_parm_data}
\title{Tabulate Parameter Data}
\usage{
tabulate_parm_data(parameters, samples)
}
\arguments{
\item{parameters}{'data.frame' table.
Parameter information for analytes, see \code{\link{parameters}} dataset for details.}

\item{samples}{'data.frame' table.
Water-quality data records, see \code{\link{samples}} dataset for details.}
}
\value{
Summary table with the following columns:
\describe{
\item{\code{parm_group_nm}}{Parameter group name.}
\item{\code{parm_nm}}{A long parameter name assigned by the USGS.}
\item{\code{pcode}}{Parameter code assigned by the USGS.}
\item{\code{min_dt}}{Date of first record.}
\item{\code{max_dt}}{Date of last record.}
\item{\code{nrecords}}{Number of records associated with the parameter.}
\item{\code{nsites}}{Number of sampling sites where the parameter was observed.}
}
}
\description{
Tabulate parameter data measured for in water samples collected from sites
in the U.S. Geological Survey water-quality monitoring network,
Idaho National Laboratory and vicinity, Idaho
}
\examples{
d <- tabulate_parm_data(parameters, samples)
str(d)
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
