% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetPolygons.R
\name{SetPolygons}
\alias{SetPolygons}
\title{Overlaying Multi-Polygon Objects}
\usage{
SetPolygons(x, y, cmd = c("gIntersection", "gDifference"),
  buffer.width = NA)
}
\arguments{
\item{x}{SpatialPolygons*.
Multi-polygon object}

\item{y}{SpatialPolygons* or Extent.
Multi-polygon object}

\item{cmd}{character.
Specifying "gIntersection", the default, cuts out portions of the \code{x} polygons
that overlay the \code{y} polygons.
If "gDifference" is specified, only those portions of the \code{x} polygons
falling outside the \code{y} polygons are copied to the output polygons.}

\item{buffer.width}{numeric.
Expands or contracts the geometry of \code{y} to include the area within the specified width, see \code{gBuffer}.
Specifying \code{NA}, the default, indicates no buffer.}
}
\value{
Returns an object of SpatialPolygons* class.
}
\description{
Determines the intersection or difference between two multi-polygon objects.
}
\details{
This function tests if the resulting geometry is valid, see \code{\link{gIsValid}}.
}
\examples{
library(sp)

m1a <- matrix(c(17.5, 24.7, 22.6, 16.5, 55.1, 55.0, 61.1, 59.7), nrow = 4, ncol = 2)
m1b <- m1a
m1b[, 1] <- m1b[, 1] + 11
p1 <- SpatialPolygons(list(Polygons(list(Polygon(m1a, FALSE), Polygon(m1b, FALSE)), 1)))
plot(p1, col = "blue")

m2a <- matrix(c(19.6, 35.7, 28.2, 60.0, 58.8, 64.4), nrow = 3, ncol = 2)
m2b <- matrix(c(20.6, 30.9, 27.3, 56.2, 53.8, 51.4), nrow = 3, ncol = 2)
p2 <- SpatialPolygons(list(Polygons(list(Polygon(m2a, FALSE), Polygon(m2b, FALSE)), 2)))
plot(p2, col = "red", add = TRUE)

p <- SetPolygons(p1, p2, "gIntersection")
plot(p, col = "green", add = TRUE)

p <- SetPolygons(p2, p1, "gDifference")
plot(p, col = "purple", add = TRUE)

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\seealso{
\code{\link{gIntersection}}, \code{\link{gDifference}}
}
\keyword{utilities}

