% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummariseBudget.R
\name{SummariseBudget}
\alias{SummariseBudget}
\title{Summarize MODFLOW Water Budget}
\usage{
SummariseBudget(budget, desc = c("wells", "drains", "river leakage"))
}
\arguments{
\item{budget}{character or list.
Either a description of the path to the MODFLOW Budget File or
the returned results from a call to the \code{\link{ReadModflowBinary}} function.}

\item{desc}{character.
Vector of MODFLOW package identifiers.
Data of this package type is included in the summary table.}
}
\value{
Returns a data.frame object with the following variables:
  \describe{
    \item{desc}{MODFLOW package identifier}
    \item{kper}{stress period}
    \item{kstp}{time step}
    \item{id}{location identifier}
    \item{delt}{length of the current time step.}
    \item{pertim}{time in the stress period.}
    \item{totim}{total elapsed time}
    \item{count}{number of cells in each subset.}
    \item{flow.sum}{total volumetric flow rate}
    \item{flow.mean}{mean volumetric flow rate}
    \item{flow.median}{median volumetric flow rate}
    \item{flow.sd}{tandard deviation of the volumetric flow rate.}
    \item{flow.dir}{flow direction where "in" and "out" indicate
      water entering and leaving the groundwater system, respectively.}
  }
}
\description{
This is a utility function for \href{https://water.usgs.gov/ogw/modflow/}{MODFLOW}.
It summarizes volumetric flow rates by boundary condition types.
That is, it splits the MODFLOW water-budget data into subsets,
computes summary statistics for each, and
returns the result in a summary table.
}
\details{
The \code{budget[[i]]$d} data table component must contain a numeric \code{id} field.
  Subsets are grouped by the MODFLOW package identifier (\code{desc}), stress period
  (\code{kper}), time step (\code{kstp}), and location identifier (\code{id}).
}
\examples{
\dontrun{
  d <- SummariseBudget("modflow.bud")
}

}
\seealso{
\code{\link{ReadModflowBinary}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
