% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotGraph.R
\name{PlotGraph}
\alias{PlotGraph}
\title{Plot Graph}
\usage{
PlotGraph(x, y, xlab, ylab, main = NULL, asp = NA, xlim = NULL,
  ylim = NULL, xn = 5, yn = 5, ylog = FALSE, type = "s",
  lty = 1, lwd = 0.7, pch = NULL, col = NULL, bg = NA,
  fill = "none", fillcolor = NULL, pt.cex = 1, xpd = FALSE,
  seq.date.by = NULL, scientific = NA, conversion.factor = NULL,
  boxwex = 0.8, center.date.labels = FALSE, bg.polygon = NULL,
  add.grid = TRUE)
}
\arguments{
\item{x, y}{'Date' vector, 'numeric' vector, 'matrix', or 'data.frame'.
Data for plotting where the vector length or number of rows should match.
If \code{y} is missing, then \code{x = x[, 1]} and \code{y = x[, -1]}.}

\item{xlab}{'character' string.
Title for \emph{x} axis.}

\item{ylab}{'character' vector of length 2.
Title for the 1st and 2nd-\emph{y} axes.
The title for the 2nd-\emph{y} axis is optional and requires \code{conversion.factor} be specified.}

\item{main}{'character' string.
Main title for the plot.}

\item{asp}{'numeric' number.
\emph{y/x} aspect ratio for spatial axes.
Defaults to 1 (one unit on the \emph{x}-axis equals one unit on the \emph{y}-axis) when \code{r} is projected,
otherwise, a calculated value based on axes limits is used.}

\item{xlim}{'numeric' or 'Date' vector of length 2.
Minimum and maximum values for the \emph{x}-axis.}

\item{ylim}{'numeric' vector of length 2.
Minimum and maximum values for the \emph{y}-axis.}

\item{xn, yn}{'integer' count.
Desired number of intervals between tick-marks on the \emph{x}- and \emph{y}-axis, respectively.}

\item{ylog}{'logical' flag.
Whether a logarithm scale is used for the \emph{y} axis.}

\item{type}{'character' string.
Plot type, possible types are
\itemize{
  \item "p" for \bold{p}oints,
  \item "l" for \bold{l}ines,
  \item "b" for \bold{b}oth points and lines,
  \item "s" for stair \bold{s}teps (default),
  \item "w" for box-and-\bold{w}hisker,
  \item "i" for \bold{i}nterval-censored data, see "Details" section below, and
  \item "n" for \bold{n}o plotting.
}}

\item{lty}{'integer' vector.
Line type, see \code{\link{par}} function for all possible types.
Line types are used cyclically.}

\item{lwd}{'numeric' number.
Line width}

\item{pch}{'integer' count.
Point type, see \code{\link{points}} function for all possible types.}

\item{col}{'character' vector or 'function'.
Point or line color, see \code{\link{par}} function for all possible ways this can be specified.
Colors are used cyclically.}

\item{bg}{'character' vector.
Background colors for the open plot symbols given by \code{pch = 21:25} as in \code{\link{points}}.}

\item{fill}{'character' string.
Used to create filled area plots. Specify
\code{"tozeroy"} to fill to zero on the \emph{y}-axis;
\code{"tominy"} to fill to the minimum \emph{y} value in the plotting region; and
\code{"tomaxy"} to fill to the maximum.
Requires plot \code{type = "l"}, \code{"b"}, and \code{"s"}.}

\item{fillcolor}{'character' vector.
Colors for basic filled area plots.
Defaults to a half-transparent variant of the line color (\code{col}).}

\item{pt.cex}{'numeric' number.
Expansion factor for the point symbols.}

\item{xpd}{'logical' flag.
Whether to prevent point and (or) line symbols from being clipped to the plot region.}

\item{seq.date.by}{'character' string, 'numeric' number, or 'difftime'.
The increment of the date sequence, see the \code{by} argument
in the \code{\link{seq.Date}} function for all possible ways this can be specified.}

\item{scientific}{'logical' vector of length 1, 2, or 3, value is recycled as necessary.
Whether axes labels should be encoded in nice scientific format.
Vector elements correspond to the \emph{x}-axis, \code{y}-axis, and second \emph{y}-axis labels.
Values are recycled as necessary.
Missing values correspond to the current default penalty (see \code{\link{options}("scipen")})
to be applied when deciding to print numeric values in fixed or scientific notation.}

\item{conversion.factor}{'numeric' number.
Conversion factor for the 2nd-\emph{y} axis.}

\item{boxwex}{'numeric' number.
Scale factor to be applied to all boxes, only applicable for box-and-whisker plots.}

\item{center.date.labels}{'logical' flag.
If true, date labels are horizontally centered between \emph{x}-axis tickmarks.}

\item{bg.polygon}{'list'.
If specified, a background polygon is drawn.
The polygon is described using a list of arguments supplied to the \code{\link{polygon}} function.
Passed arguments include \code{"x"} and \code{"col"}.}

\item{add.grid}{'logical' flag.
Whether to draw a rectangular grid.}
}
\value{
Used for the side-effect of a new plot generated.
}
\description{
Draw a sequence of points, lines, or box-and-whiskers.
}
\details{
Interval censored data (\code{type = "i"}) requires \code{y} be matrix of 2 columns.
  The first column contains the starting values, the second the ending values.
  Observations are represented using
    \code{(y0, Inf)} for right-censored value,
    \code{(y0, y0)} for exact value, and
    \code{(-Inf, y1)} for left-censored value, and
    \code{(y0, y1)} for an interval censored value.
  Where infinity is represented as \code{Inf} or \code{NA}, and \code{y} is a numeric value.
}
\examples{
n <- 50L
x <- as.Date("2008-07-12") + 1:n
y <- sample.int(n, replace = TRUE)
PlotGraph(x, y, ylab = paste("Random number in", c("meters", "feet")),
          main = "Main Title", type = "p", pch = 16, scientific = FALSE,
          conversion.factor = 3.28)

y <- data.frame(lapply(1:3, function(i) sample(n, replace = TRUE)))
PlotGraph(x, y, ylab = "Random number", pch = 1, seq.date.by = "days",
          scientific = TRUE)

y <- sapply(1:3, function(i) sample((1:100) + i * 100, n, replace = TRUE))
m <- cbind(as.numeric(x), y)
col <- GetColors(3, scheme = "bright")
PlotGraph(m, xlab = "Number", ylab = "Random number", type = "b", pch = 15:17,
          col = col, pt.cex = 0.9)
legend("topright", LETTERS[1:3], inset = 0.02, col = col, lty = 1, pch = 15:17,
       pt.cex = 0.9, cex = 0.7, bg = "white")

d <- data.frame(x = as.Date("2008-07-12") + 1:8 * 1000,
                y0 = c(NA, NA, 1, 3, 1, 4, 2, pi),
                y1 = c(1, 2, NA, NA, 4, 3, 2, pi))
PlotGraph(d, type = "i", ylim = c(0, 5), xpd = TRUE)

}
\seealso{
\code{\link[graphics]{matplot}}, \code{\link[graphics]{boxplot}}, \code{\link{AddIntervals}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
