% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindOptimalSubset.R
\name{EncodeChromosome}
\alias{EncodeChromosome}
\alias{DecodeChromosome}
\title{Encode and Decode an Integer Chromosome}
\usage{
EncodeChromosome(x, n)

DecodeChromosome(y, n)
}
\arguments{
\item{x}{'integer' vector.
Integer representation of chromosome.}

\item{n}{'integer' count.
Maximum permissible number in the integer chromosome,
used to calculate the bit width of a binary string.}

\item{y}{'integer' vector.
Binary representation of chromosome, a vector of \code{0}s and \code{1}s.}
}
\value{
\code{EncodeChromosome} returns a 'numeric' vector of \code{0}s and \code{1}s.

  \code{DecodeChromosome} returns a 'numeric' vector of integers.
}
\description{
Functions for encoding and decoding a chromosome represented by integer values.
Where a chromosome is a set of numbers that defines a proposed solution to the
problem that a genetic algorithm is trying to solve.
}
\examples{
x <- c(41, 796, 382)
y <- EncodeChromosome(x, 1000)
print(y)
x <- DecodeChromosome(y, 1000)
print(x)

}
\seealso{
\code{\link{FindOptimalSubset}}, \code{\link[GA]{binary2decimal}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{internal}
