% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateWebMap.R
\name{CreateWebMap}
\alias{CreateWebMap}
\title{Create a Web Map Using TNM Services}
\usage{
CreateWebMap(maps, ..., collapsed = TRUE, service = c("rest", "wms"))
}
\arguments{
\item{maps}{'character' vector.
TNM base maps to include in the web map.
Possible maps include \code{"Topo"}, \code{"Imagery"},
\code{"Imagery Topo"}, \code{"Hydrography"}, \code{"Hill Shade"}, and \code{"Blank"}.
All base maps are included by default.}

\item{...}{Arguments to be passed to the \code{\link[leaflet]{leaflet}} function.}

\item{collapsed}{'logical' flag.
Whether the layers control should be rendered as an icon that expands when hovered over.}

\item{service}{'character' string.
Mapping services for accessing TNM base-map tiles.
Select \code{"rest"} for representational state transfer services (the default) and
\code{"wms"} for web map services.}
}
\value{
An object of class 'leaflet', a hypertext markup language (HTML) widget object.
  See example for instructions on how to add additional graphic layers
  (such as points, lines, and polygons) to the map widget.
  Graphic layers added to the web map must be in latitude and longitude using WGS 84
  (also known as \href{https://epsg.io/4326}{EPSG:4326}).
}
\description{
Create a \href{https://leafletjs.com/}{Leaflet} map widget with base maps offered through
The National Map (\href{https://www.usgs.gov/programs/national-geospatial-program/national-map}{TNM}).
Information about the content of these base maps can be found within the
\href{https://www.usgs.gov/programs/national-geospatial-program/national-map}{TNM Base Maps} document.
}
\details{
Map \href{https://apps.nationalmap.gov/services}{service endpoints}
  are offered through TNM with no use restrictions.
  However, map content is limited to the United States and territories.
  This function integrates TNM endpoint services within an interactive web map using
  \href{https://rstudio.github.io/leaflet/}{Leaflet for R}.
}
\examples{
map <- CreateWebMap(collapsed = FALSE)
ll <- rbind(c(-112.049705, 43.517810),
            c(-122.171257, 37.456526),
            c( -77.367458, 38.947206),
            c(-149.803565, 61.187905),
            c( -80.248344, 26.080860))
map <- leaflet::addMarkers(map, ll[, 1], ll[, 2])
map

}
\seealso{
\code{\link{AddWebMapElements}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
