% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_cluster.R
\name{doKmeansClust}
\alias{doKmeansClust}
\title{Performs a k-means cluster analysis on the basis of the word-occurrence data.frame.}
\usage{
doKmeansClust(
  wordF,
  nbClust = 4,
  nbIter = 10,
  algo = "Hartigan-Wong",
  getPlot = TRUE,
  mwidth = 800,
  mheight = 800,
  formatType = "png",
  ...
)
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{nbClust}{The number of clusters.}

\item{nbIter}{The number of iterations allowed.}

\item{algo}{The algoritm used (see \code{\link[stats]{kmeans}}).}

\item{getPlot}{If \code{TRUE}, save the k-means cluster plot in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}

\item{...}{Additional arguments from the \code{\link[stats]{kmeans}} function.}
}
\value{
An object of class kmeans (see \code{\link[stats]{kmeans}}).
}
\description{
Performs a k-means cluster analysis on the basis of the word-occurrence data.frame
  using \code{\link[stats]{kmeans}} function.
}
\examples{
data("wordOccuDF")
doKmeansClust(wordF = wordOccuDF, nbClust = 2, getPlot = FALSE)
}
