% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action.R
\name{inline_link}
\alias{inline_link}
\title{Inline action link}
\usage{
inline_link(id, label, icon = NULL, meaning = label, accent = NULL)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{label}{The text appearing within the link. This can be a character
string or any other HTML, or \code{NULL} for no text (but then you will
probably at least want an \code{icon}).}

\item{icon}{An optional \code{\link[shiny:icon]{shiny::icon()}} which will appear to the left of the
link.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}

\item{accent}{A Bootstrap "accent" (such as \code{"primary"}, \code{"danger"}, etc.)
that will be used to set the class of the link (such as \code{"link-primary"},
etc.), or \code{NULL} for no special styling. See
\href{https://getbootstrap.com/docs/5.3/utilities/link/}{Bootstrap 5 link utilities}
for all the options. If you provide multiple accents in a character
vector, each one will be appended to \code{"link-"} and added to the link.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
A link widget similar to \code{\link[shiny:actionButton]{shiny::actionLink()}} that can be included in an
\code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Link examples"),
    inline("These are ", inline_link("link1", "some"), " ",
        inline_link("link2", "increasingly", accent = "danger"), " ",
        inline_link("link3", "fancy", accent = c("success", "underline-warning", "offset-2")), " ",
        inline_link("link4", "links", icon = shiny::icon("link"), accent = "info"), "!")
)
}
\seealso{
\link[shiny:actionButton]{shiny::actionLink} for how the link works with your Shiny server.
}
