% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters.R
\name{get_parameters}
\alias{get_parameters}
\alias{get_parameters.zeroinfl}
\alias{get_parameters.hurdle}
\alias{get_parameters.coxme}
\alias{get_parameters.merMod}
\alias{get_parameters.lme}
\alias{get_parameters.MixMod}
\alias{get_parameters.glmmTMB}
\alias{get_parameters.brmsfit}
\alias{get_parameters.stanreg}
\alias{get_parameters.stanmvreg}
\title{Get model parameters}
\usage{
get_parameters(x, ...)

\method{get_parameters}{zeroinfl}(x, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{get_parameters}{hurdle}(x, component = c("all", "conditional",
  "zi", "zero_inflated"), ...)

\method{get_parameters}{coxme}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{merMod}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{lme}(x, effects = c("fixed", "random"), ...)

\method{get_parameters}{MixMod}(x, effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated",
  "dispersion"), ...)

\method{get_parameters}{glmmTMB}(x, effects = c("fixed", "random"),
  component = c("all", "conditional", "zi", "zero_inflated",
  "dispersion"), ...)

\method{get_parameters}{brmsfit}(x, effects = c("fixed", "random",
  "all"), component = c("all", "conditional", "zi", "zero_inflated",
  "dispersion"), ...)

\method{get_parameters}{stanreg}(x, effects = c("fixed", "random",
  "all"), ...)

\method{get_parameters}{stanmvreg}(x, effects = c("fixed", "random",
  "all"), ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressioms). May be abbreviated.}

\item{effects}{Should variables for fixed effects, random effects
or both be returned? Only applies to mixed models. May be abbreviated.}
}
\value{
For non-Bayesian models and if \code{effects = "fixed"}, a data frame
   with two columns: the parameter names and the related point estimates; if
   \code{effects = "random"}, a list with the random effects (as returned by
   \code{ranef()}. For Bayesian models, the posterior samples from the
   requested parameters as data frame. For Anova (\code{aov()}) with error
   term, a list of parameters for the conditional, the within-subject and
   the between-subjects parameters.
}
\description{
Returns the point estimates (or posterior samples for Bayesian
   models) from a model.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_parameters(m)
}
