\name{insol-package}
\alias{insol-package}
\alias{insol}
\docType{package}
\title{Solar Radiation}

\description{Calculates insolation on tilted surfaces, computes atmospheric transmittance 
and related parameters such as: Earth radius vector, declination, sunset and sunrise, 
daylength, equation of time, vector in the direction of the sun, vector normal to surface, and some atmospheric physics.}

\details{
\tabular{ll}{
Package: \tab insol\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-04-25\cr
License: \tab GPL-2 \cr
LazyLoad: \tab yes\cr
}

}
\author{
Javier G. Corripio

Maintainer: Javier G. Corrripio <jgc@meteoexploration.com>

Additional information: \url{http://www.meteoexploration.com/R/insol/}
}
\references{

Bird, R. E. and Hulstrom, R. L. (1981a) Review, evaluation and improvements of direct irradiance models, \emph{Trans. ASME J. Solar Energy Eng.} 103, 182-192. 

Bird, R. E. and Hulstrom, R. L. (1981b) \emph{A simplified clear sky model for direct and diffuse insolation on horizontal surfaces}, 
Technical Report SERI/TR-642-761, Solar Research Institute, Golden, Colorado. 

Iqbal, M. (1983) \emph{An Introduction to Solar Radiation}, Academic Press, Toronto.

Bourges, B.: 1985, Improvement in solar declination computation, \emph{Solar Energy} 35(4), 367-369.

Corripio, J. G.: 2003, Vectorial algebra algorithms for calculating terrain parameters from DEMs and the position of the sun 
for solar radiation modelling in mountainous terrain, \emph{International Journal of Geographical Information Science} 17(1), 1-23.

Danby, J. M. Eqn. 6.16.4 in \emph{Fundamentals of Celestial Mechanics}, 2nd ed. Richmond, VA: Willmann-Bell, p. 207, 1988.

Meeus, J. 1999.  \emph{Astronomical Algorithms}. Willmann-Bell, Richmond, Virginia, USA.

Reda, I. and Andreas, A. 2003. \emph{Solar Position Algorithm for Solar Radiation Applications}. 55 pp.; NREL Report No. TP-560-34302, Revised January 2008. 
\url{http://www.nrel.gov/docs/fy08osti/34302.pdf}


\url{http://www.esrl.noaa.gov/gmd/grad/solcalc/calcdetails.html}

\url{http://scienceworld.wolfram.com/astronomy/JulianDate.html}


}

\keyword{ package }

