% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_package_configure.R
\name{stan_package_configure}
\alias{stan_package_configure}
\title{Configure an R package with built-in Stan models.}
\usage{
stan_package_configure(path = getwd(), overwrite = FALSE)
}
\arguments{
\item{path}{Character of length 1, file path to the package which will
contain Stan models in \verb{inst/stan/} at installation time.}

\item{overwrite}{Logical of length 1, whether to overwrite any existing
configuration files.}
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
Write configuration files in an R package which
compile all the Stan models in \verb{inst/stan/} when the package installs.
}
\details{
Writes configuration scripts \code{configure} and \code{configure.win}
in the directory specified by the \code{path} argument.
}
\examples{
if (identical(Sys.getenv("INSTANTIATE_EXAMPLES"), "true")) {
path <- tempfile()
stan_package_create(path = path)
list.files(path)
stan_package_configure(path = path)
list.files(path)
}
}
\seealso{
Other packages: 
\code{\link{stan_cmdstan_path}()},
\code{\link{stan_package_clean}()},
\code{\link{stan_package_compile}()},
\code{\link{stan_package_model_files}()}
}
\concept{packages}
