% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_package_model_files.R
\name{stan_package_model_files}
\alias{stan_package_model_files}
\title{List Stan model file paths.}
\usage{
stan_package_model_files(path = getwd())
}
\arguments{
\item{path}{Character of length 1, root path to start from when searching
for Stan model files.}
}
\value{
Character vector of paths to Stan model files in the package.
}
\description{
List all the paths to the Stan model files in a package.
}
\details{
All Stan models must live in the \verb{src/stan/} directory in the
package file system.
}
\examples{
path <- tempfile()
stan_package_create(path = path)
stan_package_model_files(path)
}
\seealso{
Other packages: 
\code{\link{stan_cmdstan_path}()},
\code{\link{stan_package_clean}()},
\code{\link{stan_package_compile}()},
\code{\link{stan_package_configure}()}
}
\concept{packages}
