% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_model.R
\name{species_model}
\alias{species_model}
\title{R6 class for creating a \code{species_model} object.}
\description{
An object containing the data, covariates  and other relevant information to be used in the reproducible workflow. The function \link[intSDM]{startWorkflow} acts as a wrapper in creating one of these objects. This object has additional slot functions within, which allow for further specification and customization of the reproducible workflow.
}
\examples{

## ------------------------------------------------
## Method `species_model$print`
## ------------------------------------------------

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

workflow$print()

## ------------------------------------------------
## Method `species_model$plot`
## ------------------------------------------------

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Germany')
workflow$plot(Boundary = TRUE)

## ------------------------------------------------
## Method `species_model$addStructured`
## ------------------------------------------------

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')

#Generate random species
speciesData <- data.frame(X = runif(1000, 12, 24),
                          Y = runif(1000, 56, 68),
               Response = sample(c(0,1), 1000, replace = TRUE),
               Name = 'Fraxinus_excelsior')
workflow$addStructured(dataStructured = speciesData, datasetType = 'PA',
                       datasetName = 'xx', responseName = 'Response',
                       speciesName = 'Name', coordinateNames = c('X', 'Y'))

## ------------------------------------------------
## Method `species_model$addMesh`
## ------------------------------------------------

if (requireNamespace('INLA')) {
\dontrun{
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')
workflow$addMesh(cutoff = 20000,
                 max.edge=c(60000, 80000),
                 offset= 100000)

}
}

## ------------------------------------------------
## Method `species_model$addGBIF`
## ------------------------------------------------

\dontrun{
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$addArea(countryName = 'Sweden')

workflow$addGBIF(datasetName = 'exampleGBIF',
                 datasetType = 'PA',
                 limit = 10000,
                 coordinateUncertaintyInMeters = '0,50')
}

## ------------------------------------------------
## Method `species_model$addCovariates`
## ------------------------------------------------

\dontrun{
if (requireNamespace('INLA')) {

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')
workflow$addCovariates(worldClim = 'tavg', res = '10')

}
}

## ------------------------------------------------
## Method `species_model$addArea`
## ------------------------------------------------

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')

## ------------------------------------------------
## Method `species_model$crossValidation`
## ------------------------------------------------

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

workflow$crossValidation(Method = 'Loo')

## ------------------------------------------------
## Method `species_model$modelOptions`
## ------------------------------------------------

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

workflow$modelOptions(INLA = list(control.inla=list(int.strategy = 'eb')),
                      ISDM = list(pointsIntercept = FALSE))

## ------------------------------------------------
## Method `species_model$specifySpatial`
## ------------------------------------------------

\dontrun{
if (requireNamespace('INLA')) {
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')
workflow$addMesh(cutoff = 20000,
                 max.edge=c(60000, 80000),
                 offset= 100000)
workflow$specifySpatial(prior.range = c(200000, 0.05),
                        prior.sigma = c(5, 0.1))
}
}

## ------------------------------------------------
## Method `species_model$biasFields`
## ------------------------------------------------

\dontrun{
if(requireNamespace('INLA')) {

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$addArea(countryName = 'Sweden')

workflow$addGBIF(datasetName = 'exampleGBIF',
                 datasetType = 'PA',
                 limit = 10000,
                 coordinateUncertaintyInMeters = '0,50')
workflow$biasFields(datasetName = 'exampleGBIF')
}
}

## ------------------------------------------------
## Method `species_model$workflowOutput`
## ------------------------------------------------

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$workflowOutput('Predictions')

## ------------------------------------------------
## Method `species_model$obtainMeta`
## ------------------------------------------------

\dontrun{
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$addArea(countryName = 'Sweden')

workflow$addGBIF(datasetName = 'exampleGBIF',
                 datasetType = 'PA',
                 limit = 10000,
                 coordinateUncertaintyInMeters = '0,50')
workflow$obtainMeta()
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-species_model-new}{\code{species_model$new()}}
\item \href{#method-species_model-print}{\code{species_model$print()}}
\item \href{#method-species_model-plot}{\code{species_model$plot()}}
\item \href{#method-species_model-addStructured}{\code{species_model$addStructured()}}
\item \href{#method-species_model-addMesh}{\code{species_model$addMesh()}}
\item \href{#method-species_model-addGBIF}{\code{species_model$addGBIF()}}
\item \href{#method-species_model-addCovariates}{\code{species_model$addCovariates()}}
\item \href{#method-species_model-addArea}{\code{species_model$addArea()}}
\item \href{#method-species_model-crossValidation}{\code{species_model$crossValidation()}}
\item \href{#method-species_model-modelOptions}{\code{species_model$modelOptions()}}
\item \href{#method-species_model-specifySpatial}{\code{species_model$specifySpatial()}}
\item \href{#method-species_model-biasFields}{\code{species_model$biasFields()}}
\item \href{#method-species_model-workflowOutput}{\code{species_model$workflowOutput()}}
\item \href{#method-species_model-obtainMeta}{\code{species_model$obtainMeta()}}
\item \href{#method-species_model-clone}{\code{species_model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-new"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-new}{}}}
\subsection{Method \code{new()}}{
initialize the species_model object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$new(
  Countries,
  Species,
  nameProject,
  Save,
  Directory,
  Projection,
  Quiet = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Countries}}{Name of the countries to include in the workflow.}

\item{\code{Species}}{Name of the species to include in the workflow.}

\item{\code{nameProject}}{Name of the project for the workflow.}

\item{\code{Save}}{Logical argument indicating if the model outputs should be saved.}

\item{\code{Directory}}{Directory where the model outputs should be saved.}

\item{\code{Projection}}{The coordinate reference system used in the workflow.}

\item{\code{Quiet}}{Logical variable indicating if the workflow should provide messages throughout the estimation procedure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-print"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-print}{}}}
\subsection{Method \code{print()}}{
Prints the datasets, their data type and the number of observations, as well as the marks and their respective families.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

workflow$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-plot"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-plot}{}}}
\subsection{Method \code{plot()}}{
Makes a plot of the features used in the integrated model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$plot(
  Mesh = FALSE,
  Boundary = TRUE,
  Species = FALSE,
  Covariates = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Mesh}}{Add the mesh to the plot.}

\item{\code{Boundary}}{Add the boundary to the plot.}

\item{\code{Species}}{Add the species location data to the plot.}

\item{\code{Covariates}}{Add the spatial covariates to the plot.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Germany')
workflow$plot(Boundary = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-addStructured"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-addStructured}{}}}
\subsection{Method \code{addStructured()}}{
The function is used to convert structured datasets into a framework which is usable by the model. The three types of structured data allowed by this function are present absence (PA), present only (PO) and counts/abundance datasets, which are controlled using the \code{datasetType} argument. The other arguments of this function are used to specify the appropriate variable (such as response name, trial name, species name and coordinate name) names in these datasets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$addStructured(
  dataStructured,
  datasetType,
  responseName,
  trialsName,
  datasetName = NULL,
  speciesName,
  coordinateNames,
  generateAbsences = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataStructured}}{The dataset used in the model. Must be either a \code{data.frame}, \code{sf} or \code{SpatialPoints*} object, or a \code{list} containing multiples of these classes.}

\item{\code{datasetType}}{A vector which gives the type of dataset. Must be either \code{'count'}, \code{'PO'} or \code{'PA'}.}

\item{\code{responseName}}{Name of the response variable in the dataset. If \code{dataType} is \code{'PO'}, then this argument may be missing.}

\item{\code{trialsName}}{Name of the trial name variable in the \code{PA} datasets.}

\item{\code{datasetName}}{An optional argument to create a new name for the dataset. Must be the same length as \code{dataStructured} if that is provided as a \code{list}.}

\item{\code{speciesName}}{Name of the species variable name in the datasets.}

\item{\code{coordinateNames}}{Names of the coordinate vector in the dataset.}

\item{\code{generateAbsences}}{Generates absences for \code{'PA'} data. This is done by combining all the sampling locations for all the species, and creating an absence where a given species does not occur.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')

#Generate random species
speciesData <- data.frame(X = runif(1000, 12, 24),
                          Y = runif(1000, 56, 68),
               Response = sample(c(0,1), 1000, replace = TRUE),
               Name = 'Fraxinus_excelsior')
workflow$addStructured(dataStructured = speciesData, datasetType = 'PA',
                       datasetName = 'xx', responseName = 'Response',
                       speciesName = 'Name', coordinateNames = c('X', 'Y'))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-addMesh"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-addMesh}{}}}
\subsection{Method \code{addMesh()}}{
Function to add an \code{inla.mesh} object to the workflow. The user may either add their own mesh to the workflow, or use the arguments of this function to help create one.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$addMesh(Object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Object}}{An \code{inla.mesh} object to add to the workflow.}

\item{\code{...}}{Additional arguments to pass to \code{INLA}'s \code{inla.mesh.2d}. Use \code{?inla.mesh.2d} to find out more about the different arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (requireNamespace('INLA')) {
\dontrun{
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')
workflow$addMesh(cutoff = 20000,
                 max.edge=c(60000, 80000),
                 offset= 100000)

}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-addGBIF"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-addGBIF}{}}}
\subsection{Method \code{addGBIF()}}{
Function to add species occurrence records from GBIF (using the \code{rgbif} package) to the reproducible workflow. The arguments for this function are used to either filter the GBIF records, or to specify the characteristics of the observation model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$addGBIF(
  Species = "All",
  datasetName = NULL,
  datasetType = "PO",
  responseCounts = "individualCount",
  responsePA = "occurrenceStatus",
  generateAbsences = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Species}}{The names of the species to include in the workflow (initially specified using \link[intSDM]{startWorkflow}). Defaults to \code{All}, which will find occurrence records for all specie specified in \link[intSDM]{startWorkflow}.}

\item{\code{datasetName}}{The name to give the dataset obtained from GBIF. Cannot be \code{NULL}.}

\item{\code{datasetType}}{The data type of the dataset. Defaults to \code{PO}, but may also be \code{PA} or \code{Counts}.}

\item{\code{responseCounts}}{Name of the response variable for the counts data. Defaults to the standard Darwin core value \code{individualCounts}.}

\item{\code{responsePA}}{Name of the response variable for the PA data. Defaults to the standard Darwin core value \code{occurrenceStatus}.}

\item{\code{generateAbsences}}{Generates absences for \code{'PA'} data. This is done by combining all the sampling locations for all the species, and creating an absence where a given species does not occur.}

\item{\code{...}}{Additional arguments to specify the \link[rgbif]{occ_data} function from \code{rgbif}. See \code{?occ_data} for more details.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$addArea(countryName = 'Sweden')

workflow$addGBIF(datasetName = 'exampleGBIF',
                 datasetType = 'PA',
                 limit = 10000,
                 coordinateUncertaintyInMeters = '0,50')
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-addCovariates"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-addCovariates}{}}}
\subsection{Method \code{addCovariates()}}{
Function to add spatial covariates to the workflow. The covariates may either be specified by the user, or they may come from worldClim obtained with the \code{geodata} package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$addCovariates(
  Object = NULL,
  worldClim = NULL,
  res = 2.5,
  Months = "All",
  Function = "mean",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Object}}{A object of class: \code{spatRaster}, \code{SpatialPixelsDataFrame} or \code{raster} containing covariate information across the area. Note that this function will check if the covariates span the boundary area, so it may be preferable to add your own boundary using \code{`.$addArea`} if this argument is specified.}

\item{\code{worldClim}}{Name of the worldClim to include in the model. See \code{?worldclim_country} from the \code{geodata} package for more information.}

\item{\code{res}}{Resolution of the worldclim variable. Valid options are: \code{10}, \code{5}, \code{2.5} or \code{0.5} (minutes of a degree).}

\item{\code{Months}}{The months to include the covariate for. Defaults to \code{All} which includes covariate layers for all months.}

\item{\code{Function}}{The function to aggregate the temporal data into one layer. Defaults to \code{mean}.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
if (requireNamespace('INLA')) {

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')
workflow$addCovariates(worldClim = 'tavg', res = '10')

}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-addArea"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-addArea}{}}}
\subsection{Method \code{addArea()}}{
Function to add a boundary around the study area. This function allows the user to either add their own boundary object, or obtain a country's boundary using \link[giscoR]{gisco_get_countries} from the \code{giscoR} package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$addArea(Object = NULL, countryName = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Object}}{A \code{sf} or \code{SpatialPolygons} object of the boundary surrounding the study area.}

\item{\code{countryName}}{Name of the countries to obtain a boundary for. This argument will then use the \link[giscoR]{gisco_get_countries} function from the \code{giscoR} package to obtain a boundary.}

\item{\code{...}}{Additional arguments passed to \link[giscoR]{gisco_get_countries}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-crossValidation"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-crossValidation}{}}}
\subsection{Method \code{crossValidation()}}{
Function to add a spatial cross validation method to the workflow.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$crossValidation(
  Method,
  blockOptions = list(k = 5, rows_cols = c(4, 4), plot = FALSE, seed = NULL)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Method}}{The spatial cross-validation methods to use in the workflow. May be at least one of \code{spatialBlock} or \code{Loo} (leave-one-out). See the \code{PointedSDMs} package for more details.}

\item{\code{blockOptions}}{A list of options to specify the spatial block cross-validation. Must be a named list with arguments specified for: \code{k}, \code{rows_cols}, \code{plot}, \code{seed}. See \code{blockCV::cv_spatial} for more information.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

workflow$crossValidation(Method = 'Loo')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-modelOptions"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-modelOptions}{}}}
\subsection{Method \code{modelOptions()}}{
Function to specify model options for the \code{INLA} and \code{PointedSDMs} parts of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$modelOptions(ISDM = list(), INLA = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ISDM}}{Arguments to specify in \link[PointedSDMs]{intModel} from the \code{PointedSDMs} function. This argument needs to be a named list of the following options: \code{pointCovariates}, \code{pointsIntercept}, \code{pointsSpatial} or \code{copyModel}. See \code{?intModel} for more details.}

\item{\code{INLA}}{Options to specify in \link[INLA]{INLA} from the \code{inla} function. See \code{?inla} for more details.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

workflow$modelOptions(INLA = list(control.inla=list(int.strategy = 'eb')),
                      ISDM = list(pointsIntercept = FALSE))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-specifySpatial"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-specifySpatial}{}}}
\subsection{Method \code{specifySpatial()}}{
Function to specify pc priors for the shared random field in the model. See \code{?INLA::inla.spde2.pcmatern} for more details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$specifySpatial(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed on to \link[INLA]{inla.spde2.pcmatern}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
if (requireNamespace('INLA')) {
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))

#Add boundary
workflow$addArea(countryName = 'Sweden')
workflow$addMesh(cutoff = 20000,
                 max.edge=c(60000, 80000),
                 offset= 100000)
workflow$specifySpatial(prior.range = c(200000, 0.05),
                        prior.sigma = c(5, 0.1))
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-biasFields"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-biasFields}{}}}
\subsection{Method \code{biasFields()}}{
Function to add bias fields to the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$biasFields(datasetName, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{datasetName}}{Name of the dataset to add a bias field to.}

\item{\code{...}}{Additional arguments passed on to \link[INLA]{inla.spde2.pcmatern} to customize the priors for the pc matern for the bias fields.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
if(requireNamespace('INLA')) {

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$addArea(countryName = 'Sweden')

workflow$addGBIF(datasetName = 'exampleGBIF',
                 datasetType = 'PA',
                 limit = 10000,
                 coordinateUncertaintyInMeters = '0,50')
workflow$biasFields(datasetName = 'exampleGBIF')
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-workflowOutput"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-workflowOutput}{}}}
\subsection{Method \code{workflowOutput()}}{
Function to specify the workflow output from the model. This argument must be at least one of: \code{'Model'}, \code{'Prediction'}, \code{'Maps'} and \code{'Cross-validation'}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$workflowOutput(Output)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Output}}{The names of the outputs to give in the workflow. Must be at least one of: \code{'Model'}, \code{'Prediction'}, \code{'Maps'} and \code{'Cross-validation'}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$workflowOutput('Predictions')
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-obtainMeta"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-obtainMeta}{}}}
\subsection{Method \code{obtainMeta()}}{
Obtain metadata from the workflow.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$obtainMeta(Number = TRUE, Citations = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Number}}{Print the number of observations per dataset. Defaults to \code{TRUE}.}

\item{\code{Citations}}{Print the citations for the GBIF obtained datasets. Defaults to \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$addArea(countryName = 'Sweden')

workflow$addGBIF(datasetName = 'exampleGBIF',
                 datasetType = 'PA',
                 limit = 10000,
                 coordinateUncertaintyInMeters = '0,50')
workflow$obtainMeta()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-species_model-clone"></a>}}
\if{latex}{\out{\hypertarget{method-species_model-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{species_model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
