% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\docType{package}
\name{interim-package}
\alias{interim}
\alias{interim-package}
\title{Scheduling interim analyses in clinical trials}
\description{
It is often discussed during the planning of a clinical trial whether an interim analysis
is beneficial. The time point of the interim  analysis and the end of the clinical trial
are crucial for the decision. Both  depend on the recruitment of patients and on the length
of the treatment phase. The package \code{interim} allows the instantaneous simulation and
plotting of both the recruitment and treatment phase. Based on these simulations, the
timing of interim analyses can be assessed or different recruitment scenarios
can be compared.
}
\details{
There are three main functions in this package:
\itemize{
\item \code{\link{recruitment}}
\item \code{\link{treatment}}
\item \code{\link{trialCourse}}
}

The function \code{recruitment} generally is the starting point. It simulates screening
and enrollment based on screening characteristics, like e.g. number of available centers
and patients, screen failure rate, etc.

The function \code{treatment} simulates the treatment period based on a given recruitment
scenario as simulated by \code{recruitment}.

The function \code{trialCourse} plots displays of enrollment and treatment simulations.
Two plots are provided; the first one displays center openings and the second one
displays patient screening, enrollment and treatment.

In addition to the main functions, the package comprises a number of auxilliary functions
helping to derive or convert parameters required for the three main functions,
as well as to derive and plot information on timing of interim analyses. The following
auxilliary functions are available:
\itemize{
\item \code{\link{capacity}}
\item \code{\link{convertedRate}}
\item \code{\link{trialWeek}}
\item \code{\link{cross}}
}
}
