% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldbook_mvr.R
\name{fieldbook_mvr}
\alias{fieldbook_mvr}
\title{Multivariate Analysis}
\usage{
fieldbook_mvr(data, fb_smr, summary_by, groups)
}
\arguments{
\item{data}{Field book data.}

\item{fb_smr}{Summary of the variables in the fieldbook.}

\item{summary_by}{Variables for group the analysis.}

\item{groups}{Groups for color in PCA.}
}
\value{
result and plots
}
\description{
Multivariate analysis for PCA and HCPC
}
\details{
Compute and plot information for multivariate analysis.
}
\examples{

library(inti)
library(googlesheets4)
library(FactoMineR)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=172957346")
# browseURL(url)
gs <- as_sheets_id(url)

(data <- gs \%>\%
    range_read("fb"))

(fb_smr <- gs \%>\%
  range_read("fbsm"))


mvr <- fieldbook_mvr(data, fb_smr
, summary_by = c("genotype", "treat"), groups = "treat")

FactoMineR::plot.PCA(mvr$pca
                     , choix = "ind"
                     , habillage = mvr$param$groups_n
                     , invisible = "quali"
)

FactoMineR::plot.HCPC(mvr$hcpc)

}

}
