# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute optimal adaptive intrinsic factor risk premia under generalized
#' cross validation
#'
#' @name OptimalAdaptiveIFRPGCVCpp
#' @description Computes optimal adaptive intrinsic factor risk premia based
#' on moments extracted from factors and test asset excess returns and adaptive
#' weights over various penalty parameter values. Tuning is performed via
#' Generalized Cross Validation (GCV). Adaptive weights can be based on the
#' correlation between factors and returns, on the regression coefficients of
#' returns on factors or on the first-step intrinsic risk premia estimator.
#'
#' @param returns `n_observations x n_returns`-dimensional matrix of test asset
#' excess returns.
#' @param factors `n_observations x n_factors`-dimensional matrix of factors.
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#' @param penalty_parameters `n_parameters`-dimensional vector of penalty
#' parameter values from smallest to largest.
#' @param weighting_type character specifying the type of adaptive weights:
#' based on the correlation between factors and returns `'c'`; based on the
#' regression coefficients of returns on factors `'b'`; based on the first-step
#' intrinsic risk premia estimator `'a'`; otherwise a vector of ones (any other
#' character). Default is `'c'`.
#' @param gcv_vr_weighting boolean `TRUE` for scaling pricing errors by
#' the inverse variance matrix of asset excess returns; `FALSE` otherwise.
#' Default is `FALSE`.
#' @param gcv_aic_scaling (only relevant for `tuning_type ='g'`)
#' boolean `TRUE` for AIC scaling (`1 / n_observations`); `FALSE` for BIC scaling
#' (`log(n_observations) / n_observations`). Default is `TRUE`.
#' @param one_stddev_rule boolean `TRUE` for picking the most parsimonious model
#' whose score is not higher than one standard error above the score of the
#' best model; `FALSE` for picking the best model. Default is `FALSE`.
#' @param relaxed boolean `TRUE` for re-fitting the model without shrinkage
#' post selection; `FALSE` otherwise. Default is `FALSE`.
#'
#' @return a list containing the `n_factors`-dimensional vector of adaptive
#' intrinsic factor risk premia in `"risk_premia"`, and the optimal penalty
#' parameter value in `"penalty_parameter"`.
#'
#' @noRd
#'
OptimalAdaptiveIFRPGCVCpp <- function(returns, factors, covariance_factors_returns, variance_returns, mean_returns, penalty_parameters, weighting_type = 'c', gcv_vr_weighting = FALSE, gcv_aic_scaling = TRUE, one_stddev_rule = FALSE, relaxed = FALSE) {
    .Call(`_intrinsicFRP_OptimalAdaptiveIFRPGCVCpp`, returns, factors, covariance_factors_returns, variance_returns, mean_returns, penalty_parameters, weighting_type, gcv_vr_weighting, gcv_aic_scaling, one_stddev_rule, relaxed)
}

#' Compute optimal adaptive intrinsic factor risk premia under cross validation
#'
#' @name OptimalAdaptiveIFRPCVCpp
#' @description Computes optimal adaptive intrinsic factor risk premia based
#' on moments extracted from factors and test asset excess returns and adaptive
#' weights over various penalty parameter values. Tuning is performed via
#' Cross Validation (CV). Adaptive weights can be based on the correlation
#' between factors and returns, on the regression coefficients of returns on
#' factors or on the first-step intrinsic risk premia estimator.
#'
#' @param returns `n_observations x n_returns`-dimensional matrix of test asset
#' excess returns.
#' @param factors `n_observations x n_factors`-dimensional matrix of factors.
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#' @param penalty_parameters `n_parameters`-dimensional vector of penalty
#' parameter values from smallest to largest.
#' @param weighting_type character specifying the type of adaptive weights:
#' based on the correlation between factors and returns `'c'`; based on the
#' regression coefficients of returns on factors `'b'`; based on the first-step
#' intrinsic risk premia estimator `'a'`; otherwise a vector of ones (any other
#' character). Default is `'c'`.
#' @param n_folds integer number of k-fold for cross validation. Default is `5`.
#' @param one_stddev_rule boolean `TRUE` for picking the most parsimonious model
#' whose score is not higher than one standard error above the score of the
#' best model; `FALSE` for picking the best model. Default is `FALSE`.
#' @param relaxed boolean `TRUE` for re-fitting the model without shrinkage
#' post selection; `FALSE` otherwise. Default is `FALSE`.
#'
#' @return a list containing the n_factors-dimensional vector of adaptive
#' intrinsic factor risk premia in "risk_premia", and the optimal penalty
#' parameter value in "penalty_parameter".
#'
#' @noRd
#'
OptimalAdaptiveIFRPCVCpp <- function(returns, factors, covariance_factors_returns, variance_returns, mean_returns, penalty_parameters, weighting_type = 'c', n_folds = 5L, one_stddev_rule = FALSE, relaxed = FALSE) {
    .Call(`_intrinsicFRP_OptimalAdaptiveIFRPCVCpp`, returns, factors, covariance_factors_returns, variance_returns, mean_returns, penalty_parameters, weighting_type, n_folds, one_stddev_rule, relaxed)
}

#' Compute optimal adaptive intrinsic factor risk premia under rolling validation
#'
#' @name OptimalAdaptiveIFRPRVCpp
#' @description Computes optimal adaptive intrinsic factor risk premia based
#' on moments extracted from factors and test asset excess returns and adaptive
#' weights over various penalty parameter values. Tuning is performed via
#' Rolling Validation (RV). Adaptive weights can be based on the correlation
#' between factors and returns, on the regression coefficients of returns on
#' factors or on the first-step intrinsic risk premia estimator.
#'
#' @param returns `n_observations x n_returns`-dimensional matrix of test asset
#' excess returns.
#' @param factors `n_observations x n_factors`-dimensional matrix of factors.
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#' @param penalty_parameters `n_parameters`-dimensional vector of penalty
#' parameter values from smallest to largest.
#' @param weighting_type character specifying the type of adaptive weights:
#' based on the correlation between factors and returns `'c'`; based on the
#' regression coefficients of returns on factors `'b'`; based on the first-step
#' intrinsic risk premia estimator `'a'`; otherwise a vector of ones (any other
#' character). Default is `'c'`.
#' @param n_train_observations number of observations in the rolling training
#' set. Default is `120`.
#' @param n_test_observations number of observations in the test set. Default
#' is `12`.
#' @param roll_shift number of observation shift when moving from the rolling
#' window to the next one. Default is `12`.
#' @param one_stddev_rule boolean `TRUE` for picking the most parsimonious model
#' whose score is not higher than one standard error above the score of the
#' best model; `FALSE` for picking the best model. Default is `FALSE`.
#' @param relaxed boolean `TRUE` for re-fitting the model without shrinkage
#' post selection; `FALSE` otherwise. Default is `FALSE`.
#'
#' @return a list containing the n_factors-dimensional vector of adaptive
#' intrinsic factor risk premia in "risk_premia", and the optimal penalty
#' parameter value in "penalty_parameter".
#'
#' @noRd
#'
OptimalAdaptiveIFRPRVCpp <- function(returns, factors, covariance_factors_returns, variance_returns, mean_returns, penalty_parameters, weighting_type = 'c', n_train_observations = 120L, n_test_observations = 12L, roll_shift = 12L, one_stddev_rule = FALSE, relaxed = FALSE) {
    .Call(`_intrinsicFRP_OptimalAdaptiveIFRPRVCpp`, returns, factors, covariance_factors_returns, variance_returns, mean_returns, penalty_parameters, weighting_type, n_train_observations, n_test_observations, roll_shift, one_stddev_rule, relaxed)
}

#' Compute adaptive intrinsic factor risk premia
#'
#' @name AdaptiveIFRPCpp
#' @description Computes adaptive intrinsic factor risk premia based on
#' pre-computed intrinsic factor risk premia and adaptive penalty weights for
#' various penalty parameter values.
#'
#' @param ifrp `n_factors`-dimensional vector of intrinsic factor risk premia.
#' Usually, it is the output of function `IFRPCpp`
#' @param weights `n_factors`-dimensional vector of weights for the penalty
#' term. Usually, it is the output of function `AdaptiveWeightsCpp`.
#' @param penalty_parameters `n_parameters`-dimensional vector of penalty
#' parameter values from smallest to largest.
#'
#' @return `n_factors x n_parameters`-dimensional matrix of adaptive
#' intrinsic factor risk premia.
#'
#' @noRd
#'
AdaptiveIFRPCpp <- function(ifrp, weights, penalty_parameter) {
    .Call(`_intrinsicFRP_AdaptiveIFRPCpp`, ifrp, weights, penalty_parameter)
}

#' Compute adaptive intrinsic factor risk premia
#'
#' @name RelaxedAdaptiveIFRPCpp
#' @description Computes the intrinsic factor risk premia of the factors selected
#' by an adaptive intrinsic factor risk premia.
#'
#' @param aifrp `n_factors`-dimensional vector of adaptive intrinsic factor
#' risk premia.
#' Usually, it is the output of function `AdaptiveIFRPCpp`
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#'
#' @return `n_selected_factors x n_parameters`-dimensional matrix of intrinsic
#' factor risk premia.
#'
#' @noRd
#'
RelaxedAdaptiveIFRPCpp <- function(aifrp, covariance_factors_returns, variance_returns, mean_returns) {
    .Call(`_intrinsicFRP_RelaxedAdaptiveIFRPCpp`, aifrp, covariance_factors_returns, variance_returns, mean_returns)
}

#' Compute the HAC standard errors of the nonzero adaptive intrinsic factor risk
#' premia
#'
#' @name StandardErrorsAdaptiveIFRPCpp
#' @description Computes the HAC standard errors of adaptive intrinsic factor
#' risk premia based on moments extracted from factors and test asset excess
#' returns. It uses the Newey-West (1994) plug-in procedure to select the
#' number of relevant lags, i.e., `n_lags = 4 * (n_observations/100)^(2/9)`.
#'
#' @param aifrp n_factors-dimensional vector of intrinsic factor risk
#' premia. E.g., the result of function `OptimalAdaptiveIFRPGCV` or
#' `OptimalAdaptiveIFRPCV`.
#' @param returns `n_observations x n_returns`-dimensional matrix of test asset
#' excess returns.
#' @param factors `n_observations x n_factors`-dimensional matrix of risk
#' factors.
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#' @param mean_factors `n_factors`-dimensional mean vector of risk factors.
#'
#' @noRd
#'
#' @return `n_factors`-dimensional vector of standard errors for adaptive
#' intrinsic factor risk premia.
#'
StandardErrorsAdaptiveIFRPCpp <- function(aifrp, returns, factors, covariance_factors_returns, variance_returns, mean_returns, mean_factors) {
    .Call(`_intrinsicFRP_StandardErrorsAdaptiveIFRPCpp`, aifrp, returns, factors, covariance_factors_returns, variance_returns, mean_returns, mean_factors)
}

#' Compute adaptive weights from data on factors and test asset excess returns
#'
#' @name AdaptiveWeightsCpp
#' @description Computes adaptive weights from data on factors and test asset
#' excess returns. The possible adaptive weights are based on: the first-step
#' intrinsic factor risk premia estimates with choice `a`; the matrix of
#' factors regression coefficients on test asset excess returns with choice
#' `b`; the correlation matrix between factors and returns with choice `c`;
#' the unit vector with any other character.
#'
#' @param returns `n_observations x n_returns`-dimensional matrix of test asset
#' excess returns.
#' @param factors `n_observations x n_factors`-dimensional matrix of risk
#' factors.
#' @param type character specifying the type of adaptive weights:
#' based on the correlation between factors and returns `'c'`; based on the
#' regression coefficients of returns on factors `'b'`; based on the first-step
#' intrinsic risk premia estimator `'a'`; otherwise a vector of ones (any other
#' character). Default is `'c'`.
#'
#' @return 'n_factors'-dimensional vector of adaptive weights.
#'
#' @noRd
#'
AdaptiveWeightsCpp <- function(returns, factors, type = 'c') {
    .Call(`_intrinsicFRP_AdaptiveWeightsCpp`, returns, factors, type)
}

#' Compute standard factor risk premia from moments extracted from data
#'
#' @name FRPCpp
#' @description Computes Fama MacBeth (1973) factor risk premia based on moments
#' extracted from factors and test asset returns.
#'
#' @param beta `n_returns x n_factors`-dimensional regression coefficient
#' matrix of test asset returns on risk factors: `beta =
#' covariance(returns, factors) * variance(factors)^(-1)`.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#'
#' @return `n_factors`-dimensional vector of factor risk premia.
#'
#' @noRd
#'
FRPCpp <- function(beta, mean_returns) {
    .Call(`_intrinsicFRP_FRPCpp`, beta, mean_returns)
}

#' Compute the misspecification robust factor risk premia of Kan Robotti
#' Shanken (2013) from moments extracted from data
#'
#' @name KRSFRP
#' @description Computes misspecification-robust factor risk premia of
#' Kan Robotti Shanken (2013) based on moments extracted from factors and test
#' asset excess returns.
#'
#' @param beta `n_returns x n_factors`-dimensional regression coefficient
#' matrix of test asset returns on risk factors: `beta =
#' covariance(returns, factors) * variance(factors)^(-1)`.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#' @param weighting_matrix `n_returns x n_returns`-dimensional weighting
#' matrix. Typically it is the inverse covariance matrix or the
#' second-moment matrix of test asset excess returns, or the asymptotic
#' covariance of the pricing errors.
#'
#' @return `n_factors`-dimensional vector of factor risk premia.
#'
#' @noRd
#'
KRSFRPCpp <- function(beta, mean_returns, weighting_matrix) {
    .Call(`_intrinsicFRP_KRSFRPCpp`, beta, mean_returns, weighting_matrix)
}

#' Compute the standard errors of Fama-MacBeth factor risk premia from moments
#'
#' @name StandardErrorsFRPCpp
#' @description Computes the HAC standard errors of Fama MacBeth (1973) factor risk
#' premia based on moments extracted from factors and test asset excess returns.
#' It uses the Newey-West (1994) plug-in procedure to select the
#' number of relevant lags, i.e., `n_lags = 4 * (n_observations/100)^(2/9)`.
#'
#' @param frp `n_factors`-dimensional vector of factor risk premia.
#' E.g., the result of function `FRPCpp`.
#' @param returns `n_observations x n_returns`-dimensional matrix of test asset
#' excess returns.
#' @param factors `n_observations x n_factors`-dimensional matrix of risk
#' factors.
#' @param beta `n_returns x n_factors`-dimensional regression coefficient
#' matrix of test asset returns on risk factors: `beta =
#' covariance(returns, factors) * variance(factors)^(-1)`.
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param variance_factors `n_factors x n_factors`-dimensional covariance
#' matrix of factors.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#' @param mean_factors `n_factors`-dimensional mean vector of risk factors.
#'
#'
#' @return `n_factors`-dimensional vector of standard errors for the Fama-MacBeth
#' factor risk premia.
#'
#' @noRd
#'
StandardErrorsFRPCpp <- function(frp, returns, factors, beta, covariance_factors_returns, variance_returns, variance_factors, mean_returns, mean_factors) {
    .Call(`_intrinsicFRP_StandardErrorsFRPCpp`, frp, returns, factors, beta, covariance_factors_returns, variance_returns, variance_factors, mean_returns, mean_factors)
}

#' Compute the standard errors of krs factor risk premia from moments
#'
#' @name StandardErrorsKRSFRPCpp
#' @description Computes the HAC standard errors of misspecification-robust factor
#' risk premia of Kan Robotti Shanken (2013) based on moments extracted from
#' factors and test asset excess returns. It uses the Newey-West (1994) plug-in procedure to select the
#' number of relevant lags, i.e., `n_lags = 4 * (n_observations/100)^(2/9)`.
#'
#' @param krs_frp `n_factors`-dimensional vector of krs factor risk premia.
#' E.g., the result of function `KRSFRPCpp`.
#' @param returns `n_observations x n_returns`-dimensional matrix of test asset
#' excess returns.
#' @param factors `n_observations x n_factors`-dimensional matrix of risk
#' factors.
#' @param beta `n_returns x n_factors`-dimensional regression coefficient
#' matrix of test asset returns on risk factors: `beta =
#' covariance(returns, factors) * variance(factors)^(-1)`.
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and  test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param variance_factors `n_factors x n_factors`-dimensional covariance
#' matrix of factors.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#' @param mean_factors `n_factors`-dimensional mean vector of risk factors.
#'
#' @return `n_factors`-dimensional vector of HAC standard errors for the krs factor
#' risk premia.
#'
#' @noRd
#'
StandardErrorsKRSFRPCpp <- function(krs_frp, returns, factors, beta, covariance_factors_returns, variance_returns, variance_factors, mean_returns, mean_factors) {
    .Call(`_intrinsicFRP_StandardErrorsKRSFRPCpp`, krs_frp, returns, factors, beta, covariance_factors_returns, variance_returns, variance_factors, mean_returns, mean_factors)
}

#' Compute intrinsic factor risk premia from moments extracted from data
#'
#' @name IFRPCpp
#' @description Computes intrinsic factor risk premia based on moments
#' extracted from factors and test asset excess returns.
#'
#' @param covariance_factors_returns `n_factors x n_returns`-dimensional
#' covariance matrix between factors and test asset excess returns.
#' @param variance_returns `n_returns x n_returns`-dimensional covariance
#' matrix of test asset excess returns.
#' @param mean_returns `n_returns`-dimensional mean vector of test asset excess
#' returns.
#'
#' @return `n_factors`-dimensional vector of intrinsic factor risk premia.
#'
#' @noRd
#'
IFRPCpp <- function(covariance_factors_returns, variance_returns, mean_returns) {
    .Call(`_intrinsicFRP_IFRPCpp`, covariance_factors_returns, variance_returns, mean_returns)
}

#' Compute the HAC standard errors of intrinsic factor risk premia
#'
#' @name StandardErrorsIFRPCpp
#' @description Computes the HAC standard errors of intrinsic factor risk
#' premia based on moments extracted from factors and test asset excess returns.
#' It uses the Newey-West (1994) plug-in procedure to select the
#' number of relevant lags, i.e., `n_lags = 4 * (n_observations/100)^(2/9)`.
#'
#' @param ifrp n_factors-dimensional vector of intrinsic factor risk premia.
#' E.g., the result of function 'IFRPFCpp'.
#' @param returns (n_observations x n_returns)-dimensional matrix of test asset
#' excess returns.
#' @param factors (n_observations x n_factors)-dimensional matrix of risk
#' factors.
#' @param covariance_factors_returns (n_factors x n_returns)-dimensional
#' covariance matrix between factors and  test asset excess returns.
#' @param variance_returns (n_returns x n_returns)-dimensional covariance
#' matrix of test asset excess returns.
#' @param mean_returns n_returns-dimensional mean vector of test asset excess
#' returns.
#' @param mean_factors n_factors-dimensional mean vector of risk factors.
#'
#' @return n_factors-dimensional vector of HAC standard errors for
#' intrinsic factor risk premia.
#'
#' @noRd
#'
StandardErrorsIFRPCpp <- function(ifrp, returns, factors, covariance_factors_returns, variance_returns, mean_returns, mean_factors) {
    .Call(`_intrinsicFRP_StandardErrorsIFRPCpp`, ifrp, returns, factors, covariance_factors_returns, variance_returns, mean_returns, mean_factors)
}

