% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.intsel_cv.R
\name{plot.intsel_cv}
\alias{plot.intsel_cv}
\title{Plots for \code{intsel_cv}}
\usage{
\method{plot}{intsel_cv}(x, type = "cv-curve", ...)
}
\arguments{
\item{x}{The \code{\link{intsel_cv}} object.}

\item{type}{Character string, "\code{solution-path}" to generate a solution path with marks at \code{lambda.min} and \code{lambda.1se}; "\code{cv-curve}" to generate a cross-validation curve.}

\item{...}{Other graphical parameters to plot}
}
\value{
The "\code{solution-path}" plot produces a coefficient profile plot of the coefficient paths for a fitted \code{\link{intsel}} model. The "\code{cv-curve}" plot is the \code{cvm} (red dot) for each lambda with its standard error (vertical bar). The two vertical dashed lines corresponds to the \code{lambda.min} and \code{lambda.1se}.
}
\description{
Plot the solution path or cross-validation curves produced by \code{\link{intsel_cv}()}.
}
\examples{
n <- 1000
p.int <- 5
p.noint <- 3
intercept <- TRUE
p.screen <- 5

p.int.expand <- p.int*(p.int-1)/2
p.main <- p.int + p.noint
x <- matrix(rnorm(n * p.main), nrow = n, ncol = p.main)

# true model
# logit(p) = 0.1 + 0.3 x1 + 0.3 x2 + 0.3 x8 + 0.2 * x1 * x2

beta.true <- rep(0, p.main)
beta.true[c(1, 2, p.main)] <- 0.3
eta <- x \%*\% beta.true + 0.2 * x[, 1] * x[, 2]

if (intercept) eta <- eta + 0.1

py <- 1/(1 + exp(-eta))

y <- rbinom(n, 1, py)

nlam <- 30
lambdas <- exp(seq(log(0.1), log(0.00005), length.out = nlam))

# All the pairwise two-way interactions for the first p.screen variables 
# are included in the model and screened in a data-driven manner.
cv <- intsel_cv(x = x,
                y = y,
                p.screen =5,
                intercept = intercept,
                stepsize_init = 1,
                lambda = lambdas,
                nfolds = 5,
                foldid = NULL)
plot(cv)
plot(cv, type = "solution-path") 
}
\seealso{
\code{\link{intsel}}, \code{\link{intsel_cv}}.
}
