% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occurrencesLessThan.R
\name{occurrencesLessThan}
\alias{occurrencesLessThan}
\title{Identifies Infrequent inverseRegex Patterns in an R Object.}
\usage{
occurrencesLessThan(x, fraction = 0.05, n = NULL, ...)
}
\arguments{
\item{x}{Object to analyse for infrequent regex patterns.}

\item{fraction}{Fraction of the R object size; regex patterns that occur less
(or equal) often than this will be identified. For a vector this fraction will
be multiplied by the length of the object; for a matrix it will be multiplied by
the total number of entries; and for a data frame or tibble it will be multiplied
by the number of rows. Defaults to \code{0.05}.}

\item{n}{Alternative to the \code{fraction} argument which allows a literal
number of occurrences to be searched for. Defaults to NULL, in which case
\code{fraction} will be used.}

\item{...}{Other arguments to be passed to \code{inverseRegex}.}
}
\value{
A collection of logical values with \code{TRUE} indicating entries with
an infrequent regex pattern. The class of the return value will depend on the
input object; matrices, data frames, and tibbles will be returned in kind; all
others are returned as vectors.
}
\description{
Calls \code{inverseRegex} on the input object and identifies values that
occur infrequently.
}
\details{
This function is essentially a wrapper around calling \code{table()} on
the return value of \code{inverseRegex}. It can be used to identify the indices
of values that consist of a regex pattern different to others in the R object.
}
\note{
NA values are not considered and will need to be identified separately.
}
\examples{
occurrencesLessThan(c(LETTERS, 1))

x <- iris
x$Species <- as.character(x$Species)
x[27, 'Species'] <- 'set0sa'
apply(occurrencesLessThan(x), 2, which)

}
\seealso{
inverseRegex, regex
}
\author{
Jasper Watson
}
