% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_compare_models.R
\name{compare_models.pk}
\alias{compare_models.pk}
\title{Model comparison for [pk()] objects}
\usage{
\method{compare_models}{pk}(
  obj,
  newdata = NULL,
  model = NULL,
  method = NULL,
  criterion = "AIC",
  ...
)
}
\arguments{
\item{obj}{A [pk()] model object. Must be fitted, or the function will exit
with an error.}

\item{newdata}{Optional: A `data.frame` containing new data for which to
compute the TK stats. Must contain at least variables `Chemical`,
`Species`, `Route`, `Media`, `Dose`, and any other variables named in
`tk_grouping`. Default `NULL`, to use the data in `obj$data`.}

\item{model}{Character: One or more of the models fitted. Default `NULL` to
return TK stats for all models.}

\item{method}{Character: One or more of the [optimx::optimx()] methods used.
Default `NULL` to return TK stats for all methods.}

\item{criterion}{The name of a criterion function to use for model
comparison. Default "AIC". Must be the name of a function that (as for
`AIC`) accepts arguments `obj`, `newdata`, `method` and `model` (may accept
other arguments, specified in `...`) and returns output as for `AIC`: a
named list of numeric vectors (named for each of the model names in
`model`), where each vector has elements named for each of the method names
in `method`, containing the criterion value calculated for that model
fitted using that method.}

\item{...}{Optional: Other arguments to `criterion` function.}
}
\value{
A `data.frame` with variables
- `model`: The name of each model
- `method`: The name of each method
- A variable named for `criterion` (e.g. if `criterion = "AIC"` then the result will have a
  variable named `AIC`): The criterion value for each model/method
}
\description{
Perform model comparison for a fitted [pk()] object.
}
\details{
Models are compared according to the goodness-of-fit criterion named in
"criterion", and the name of the winning model is returned.
}
\author{
Caroline Ring
}
