% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qread.R
\name{qread}
\alias{qread}
\title{Data input}
\usage{
qread(file, type = NULL, ...)
}
\arguments{
\item{file}{file name (character or \code{filenamer::filename}),
a readable text-mode connection (for some types),
or path to existing directory}

\item{type}{data or file type}

\item{...}{other arguments passed to the underlying function}
}
\value{
a data object (type depends on the underlying function)
}
\description{
This function reads a file in a specified format.
}
\details{
If \code{type} is \code{NULL}, the file type is inferred from 
the file extension.
Use \code{\link{io_supported}} to check support for a file or data type.
}
\examples{
\dontrun{
data(cars)

# write data to an RDS file
qwrite(cars, "cars.rds")
# infer output type based on the class of the cars object
qwrite(cars, "cars.dfm", type=NA)

# read data back in
x1 <- qread("cars.rds")
# specify the type explicitly
x3 <- qread("cars.dfm", type="data.frame")

# read all files (with extension) in current directory
xs <- qread(".", pattern="cars")
}

}
