% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backward_linkages.R
\name{backward_linkages}
\alias{backward_linkages}
\title{Backward linkages}
\usage{
backward_linkages(Im)
}
\arguments{
\item{Im}{A Leontieff inverse matrix created by the \code{\link{leontieff_inverse_create}} function.}
}
\description{
Backward linkeages as defined by the Eurostat Manual of Supply, Use and Input-Output
Tables (see page 506.)
}
\examples{
de_use <- use_table_get ( source = "germany_1990", geo = "DE",
               year = 1990, unit = "MIO_EUR", 
               households = FALSE, labelling = "iotables")

de_output <- output_get ( source = "germany_1990", geo = "DE",
               year = 1990, unit = "MIO_EUR",
               households = FALSE, labelling = "iotables")

de_coeff <- input_coefficient_matrix_create( de_use, de_output, digits = 4)

L <- iotables::leontieff_matrix_create( technology_coefficients_matrix = de_coeff )
I <- leontieff_inverse_create (L)
backward_linkages ( I )

}
