% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{zstat_generic}
\alias{zstat_generic}
\title{Compute Z-Statistic and P-Value}
\usage{
zstat_generic(value1, value2, std_diff, alternative, diff = 0)
}
\arguments{
\item{value1}{(numeric): The first value or sample mean.}

\item{value2}{(numeric): The second value or sample mean.}

\item{std_diff}{(numeric): The standard error of the difference between the
two values.}

\item{alternative}{(character): The alternative hypothesis. Can be one of
"two-sided" (or "2-sided", "2s"), "larger" (or "l"), or "smaller" (or "s").}

\item{diff}{(numeric, optional): The hypothesized difference between the
two values. Default is 0.}
}
\value{
(list): A list containing the following:
\describe{
\item{zstat}{(numeric): The computed z-statistic.}
\item{pvalue}{(numeric): The corresponding p-value for the test.}
}
}
\description{
Computes the z-statistic and the corresponding p-value for a given test.
}
\examples{

value1 <- 1.5

value2 <- 1.0

std_diff <- 0.2

alternative <- "two-sided"

result <- zstat_generic(value1, value2, std_diff, alternative)

}
