% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipg_singlesample.R
\name{ipg_singlesample}
\alias{ipg_singlesample}
\title{Growth parameter estimates for single sample}
\usage{
ipg_singlesample(data, time.name, y.name, epsilon = 0.2/100)
}
\arguments{
\item{data}{Input data frame containing the time and dependent variable (y) from a single biological sample.
Data needs to be in long format (i.e. one row per time point).
Remove rows with missing in the dependent variable (y).}

\item{time.name}{Name of the time variable. The variable needs to be numeric.}

\item{y.name}{Name of the dependent variable (y). The variable needs to be numeric.}

\item{epsilon}{Convergence threshold for max y time calculation.
The input represents the fraction of the range of the observed dependent variable (y).
The input needs to be between 0 and 1, and a small value is recommended. Default is 0.2\%.}
}
\value{
A list that contains a table of estimates, the polynomial model, a table of beta coefficients, and a table of fitted values.
Growth parameters include peak growth rate, peak growth time, doubling time (at the peak growth), lag time, max y, and max y time.
}
\description{
This function estimates growth parameters for a single (biological) sample. Technical replicates (multiple time series) are allowed.
}
\details{
This function calculates growth curve parameters for a single sample.
A 4th degree polynomial is fit to the input data using ordinary least squares estimation.
Peak growth time is identified using the second derivative of the estimated polynomial function.
Peak growth rate is calculated using the first derivative at peak growth time.
Doubling time at peak growth is calculated using the equation: ln(2)/peak growth rate .
Lag time is determined using linear interpolation of the peak growth rate to identify the start of the exponential growth phase.
Max y time is identified by convergence of the dependent variable where the growth curve reaches an asymptote, with convergence threshold epsilon.
Max y is the value of the fitted polynomial function at max y time.
}
\examples{
library(dplyr)
data <- growthrates::bactgrowth
df.singlesample <- data \%>\% dplyr::filter(strain == "D", conc == 0)
out.singlesample <- ipg_singlesample(data = df.singlesample, time.name = "time", y.name = "value")
}
